% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-volume.R
\name{Volume}
\alias{Volume}
\title{R6 Class representing a Volume}
\description{
R6 Class representing a resource for managing volumes.
}
\examples{

## ------------------------------------------------
## Method `Volume$print`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print volume object
 volume_object$print()
}


## ------------------------------------------------
## Method `Volume$reload`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload volume object
 volume_object$reload()
}


## ------------------------------------------------
## Method `Volume$update`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Update volume object
 volume_object$update(description = description)
}


## ------------------------------------------------
## Method `Volume$deactivate`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Deactivate volume
 volume_object$deactivate()
}


## ------------------------------------------------
## Method `Volume$reactivate`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Deactivate volume
 volume_object$deactivate()

 # Reactivate volume
 volume_object$reactivate()
}


## ------------------------------------------------
## Method `Volume$delete`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Delete volume
 volume_object$delete()
}


## ------------------------------------------------
## Method `Volume$list_contents`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List volume contents
 volume_object$list_contents()
}


## ------------------------------------------------
## Method `Volume$get_file`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get volume file
 volume_object$get_file(location = location)
}


## ------------------------------------------------
## Method `Volume$list_members`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List volume members
 volume_object$list_members()
}


## ------------------------------------------------
## Method `Volume$add_member`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Add volume member
 volume_object$add_member(
                user = user,
                permissions = list(read = TRUE, copy = FALSE)
              )
}


## ------------------------------------------------
## Method `Volume$add_member_team`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Add volume member
 volume_object$add_member_team(
                team = <team-id>,
                permissions = list(read = TRUE, copy = FALSE)
              )
}


## ------------------------------------------------
## Method `Volume$add_member_division`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Add volume member
 volume_object$add_member_division(
                division = <division-id>,
                permissions = list(read = TRUE, copy = FALSE)
              )
}


## ------------------------------------------------
## Method `Volume$remove_member`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Remove volume member
 volume_object$remove_member(member = member)
}


## ------------------------------------------------
## Method `Volume$get_member`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get volume member
 volume_object$get_member(member = member)
}


## ------------------------------------------------
## Method `Volume$modify_member_permissions`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Modify volume member permissions
 volume_object$modify_member_permissions(
                    member = member,
                    permission = list(read = TRUE, copy = TRUE)
                  )
}


## ------------------------------------------------
## Method `Volume$list_imports`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List volume imports
 volume_object$list_imports(
                    project = project,
                    state = c("RUNNING", "FAILED")
                  )
}


## ------------------------------------------------
## Method `Volume$list_exports`
## ------------------------------------------------

\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List volume exports
 volume_object$list_exports(state = c("RUNNING", "FAILED"))
}

}
\section{Super class}{
\code{\link[sevenbridges2:Item]{sevenbridges2::Item}} -> \code{Volume}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}

\item{\code{id}}{Volume ID, constructed from \code{{division}/{volume_name}} or \cr
\code{{volume_owner}/{volume_name}}.}

\item{\code{name}}{The name of the volume. It must be unique from all
other volumes for this user. Required if \code{from_path} parameter
is not provided.}

\item{\code{description}}{The description of the volume.}

\item{\code{access_mode}}{Signifies whether this volume should be used
for read-write (RW) or read-only (RO) operations. The access mode is
consulted independently of the credentials granted to Seven Bridges
when the volume was created, so it is possible to use a read-write
credentials to register both read-write and read-only volumes using it.
Default: \code{"RW"}.}

\item{\code{service}}{This object in form of string more closely describes the
mapping of the volume to the cloud service where the data is stored.}

\item{\code{created_on}}{The date and time this volume was created.}

\item{\code{modified_on}}{The date and time this volume was last modified.}

\item{\code{active}}{If a volume is deactivated, this field will be
set to \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Volume-new}{\code{Volume$new()}}
\item \href{#method-Volume-print}{\code{Volume$print()}}
\item \href{#method-Volume-reload}{\code{Volume$reload()}}
\item \href{#method-Volume-update}{\code{Volume$update()}}
\item \href{#method-Volume-deactivate}{\code{Volume$deactivate()}}
\item \href{#method-Volume-reactivate}{\code{Volume$reactivate()}}
\item \href{#method-Volume-delete}{\code{Volume$delete()}}
\item \href{#method-Volume-list_contents}{\code{Volume$list_contents()}}
\item \href{#method-Volume-get_file}{\code{Volume$get_file()}}
\item \href{#method-Volume-list_members}{\code{Volume$list_members()}}
\item \href{#method-Volume-add_member}{\code{Volume$add_member()}}
\item \href{#method-Volume-add_member_team}{\code{Volume$add_member_team()}}
\item \href{#method-Volume-add_member_division}{\code{Volume$add_member_division()}}
\item \href{#method-Volume-remove_member}{\code{Volume$remove_member()}}
\item \href{#method-Volume-get_member}{\code{Volume$get_member()}}
\item \href{#method-Volume-modify_member_permissions}{\code{Volume$modify_member_permissions()}}
\item \href{#method-Volume-list_imports}{\code{Volume$list_imports()}}
\item \href{#method-Volume-list_exports}{\code{Volume$list_exports()}}
\item \href{#method-Volume-clone}{\code{Volume$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-new"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-new}{}}}
\subsection{Method \code{new()}}{
Create a new Volume object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$new(res = NA, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{res}}{Response containing Volume object info.}

\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-print"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-print}{}}}
\subsection{Method \code{print()}}{
Print method for Volume class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$print()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print volume object
 volume_object$print()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-reload"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-reload}{}}}
\subsection{Method \code{reload()}}{
Reload Volume object information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$reload(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Volume}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload volume object
 volume_object$reload()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-update"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-update}{}}}
\subsection{Method \code{update()}}{
Update a volume.
This function updates the details of a specific volume.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$update(description = NULL, access_mode = NULL, service = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{description}}{The new description of the volume.}

\item{\code{access_mode}}{Signifies whether this volume should be used
for read-write (RW) or read-only (RO) operations. The access mode is
consulted independently of the credentials granted to Seven Bridges
when the volume was created, so it is possible to use a read-write
credentials to register both read-write and read-only volumes using it.
Default: \code{"RW"}.}

\item{\code{service}}{This object in form of string more closely describes the
mapping of the volume to the cloud service where the data is stored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Volume}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Update volume object
 volume_object$update(description = description)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-deactivate"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-deactivate}{}}}
\subsection{Method \code{deactivate()}}{
Deactivate volume.
Once deactivated, you cannot import from, export to, or browse within a
volume. As such, the content of the files imported from this volume
will no longer be accessible on the Platform. However, you can update
the volume and manage members. \cr
Note that you cannot deactivate the volume if you have running imports
or exports unless you force the operation using the query parameter
force=TRUE.
Note that to delete a volume, first you must deactivate it and delete
all files which have been imported from the volume to the Platform.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$deactivate(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other query parameters or arguments that can be passed to
core \code{api()} function like 'force'.
Use it within query parameter, like \code{query = list(force = TRUE)}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Deactivate volume
 volume_object$deactivate()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-reactivate"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-reactivate}{}}}
\subsection{Method \code{reactivate()}}{
Reactivate volume.
This function reactivates the previously deactivated volume by updating
the \code{active} field of the volume to \code{TRUE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$reactivate(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other query parameters or arguments that can be passed to
core \code{api()} function like 'force'.
Use it within query parameter, like \code{query = list(force = TRUE)}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Volume}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Deactivate volume
 volume_object$deactivate()

 # Reactivate volume
 volume_object$reactivate()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-delete}{}}}
\subsection{Method \code{delete()}}{
Delete volume.
This call deletes a volume you've created to refer to storage on
Amazon Web Services, Google Cloud Storage, Azure or Ali cloud.
To be able to delete a volume, you first need to deactivate it and then
delete all files on the Platform that were previously imported from
the volume.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$delete()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Delete volume
 volume_object$delete()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-list_contents"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-list_contents}{}}}
\subsection{Method \code{list_contents()}}{
List volume contents.
This call lists the contents of a specific volume.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$list_contents(
  prefix = NULL,
  limit = getOption("sevenbridges2")$limit,
  link = NULL,
  continuation_token = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{This is parent parameter in volume context. If specified,
the content of the parent directory on the current volume is listed.}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{link}}{Link to use in the next chunk of results. Contains limit and
continuation_token. If provided it will overwrite other arguments'
values passed.}

\item{\code{continuation_token}}{Continuation token received to use for next
chunk of results. Behaves similarly like offset parameter.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields' for example. With fields parameter you can specify a
subset of fields to include in the response.
You can use: \code{href}, \code{location}, \code{volume}, \code{type}, \code{metadata}, \verb{_all}.
Default: \verb{_all}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{VolumeContentCollection}} object containing
list of \code{\link{VolumeFile}} and \code{\link{VolumePrefix}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List volume contents
 volume_object$list_contents()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-get_file"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-get_file}{}}}
\subsection{Method \code{get_file()}}{
Get volume file information.
This function returns the specific Volume File.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$get_file(location = NULL, link = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{location}}{Volume file id, which is represented as file
location.}

\item{\code{link}}{Link to the file resource received from listing volume's
contents. Cannot be used together with location.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{VolumeFile}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get volume file
 volume_object$get_file(location = location)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-list_members"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-list_members}{}}}
\subsection{Method \code{list_members()}}{
List members of a volume.
This function returns the members of a specific volume.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$list_members(
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other parameters that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} containing \code{\link{Member}}
objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List volume members
 volume_object$list_members()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-add_member"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-add_member}{}}}
\subsection{Method \code{add_member()}}{
Add member to a volume.
This function adds members to the specified volume.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$add_member(
  user,
  permissions = list(read = TRUE, copy = FALSE, write = FALSE, admin = FALSE)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{The Seven Bridges Platform username of the person
you want to add to the volume or object of class Member containing
user's username.}

\item{\code{permissions}}{List of permissions granted to the user being added.
Permissions include listing the contents of a volume, importing files
from the volume to the Platform, exporting files from the Platform to
the volume, and admin privileges. \cr
It can contain fields: 'read', 'copy', 'write' and 'admin' with
logical fields - TRUE if certain permission is allowed to the user, or
FALSE if it's not.
Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{  permissions = list(read = TRUE, copy = TRUE, write = FALSE,
  admin = FALSE)
}\if{html}{\out{</div>}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Member}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Add volume member
 volume_object$add_member(
                user = user,
                permissions = list(read = TRUE, copy = FALSE)
              )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-add_member_team"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-add_member_team}{}}}
\subsection{Method \code{add_member_team()}}{
Add a specific team as a member to a volume.
Only Enterprise users that are part of some division can add teams
to a volume created within that division.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$add_member_team(
  team,
  permissions = list(read = TRUE, copy = FALSE, write = FALSE, admin = FALSE)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{team}}{The Seven Bridges Platform ID of a team
you want to add to the volume or object of class Team containing
team's ID. Team must be created within a division where the volume is
created too.}

\item{\code{permissions}}{List of permissions granted to the team being added.
Permissions include listing the contents of a volume, importing files
from the volume to the Platform, exporting files from the Platform to
the volume, and admin privileges. \cr
It can contain fields: 'read', 'copy', 'write' and 'admin' with
logical fields - TRUE if certain permission is allowed to the team, or
FALSE if it's not.
Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{  permissions = list(read = TRUE, copy = TRUE, write = FALSE,
  admin = FALSE)
}\if{html}{\out{</div>}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Member}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Add volume member
 volume_object$add_member_team(
                team = <team-id>,
                permissions = list(read = TRUE, copy = FALSE)
              )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-add_member_division"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-add_member_division}{}}}
\subsection{Method \code{add_member_division()}}{
Add a specific division as a member to a volume.
Only Enterprise users (with Enterprise accounts) can add divisions to a
volume that is created with that Enterprise account (not within other
divisions).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$add_member_division(
  division,
  permissions = list(read = TRUE, copy = FALSE, write = FALSE, admin = FALSE)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{division}}{The Seven Bridges Platform ID of a division
you want to add to the volume or object of class Division containing
division's ID.}

\item{\code{permissions}}{List of permissions granted to the division being
added. Permissions include listing the contents of a volume, importing
files from the volume to the Platform, exporting files from the
Platform to the volume, and admin privileges. \cr
It can contain fields: 'read', 'copy', 'write' and 'admin' with
logical fields - TRUE if certain permission is allowed to the division,
or FALSE if it's not.
Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{  permissions = list(read = TRUE, copy = TRUE, write = FALSE,
  admin = FALSE)
}\if{html}{\out{</div>}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Member}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Add volume member
 volume_object$add_member_division(
                division = <division-id>,
                permissions = list(read = TRUE, copy = FALSE)
              )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-remove_member"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-remove_member}{}}}
\subsection{Method \code{remove_member()}}{
Remove member from a volume.
This function removes members from the specified volume.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$remove_member(member)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{member}}{The Seven Bridges Platform username of the person
you want to remove from the volume, or team ID or division ID
(for Enterprise users only) or object of class Member containing
member's ID.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Remove volume member
 volume_object$remove_member(member = member)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-get_member"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-get_member}{}}}
\subsection{Method \code{get_member()}}{
Get member's details.
This function returns member's information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$get_member(member, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{member}}{The Seven Bridges Platform username of the person
you want to get information about, or team ID or division ID
(for Enterprise users only) or object of class Member containing
member's ID.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Member}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get volume member
 volume_object$get_member(member = member)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-modify_member_permissions"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-modify_member_permissions}{}}}
\subsection{Method \code{modify_member_permissions()}}{
Modify volume member's permissions.
This function modifies the permissions for a member of a specific
volume. Note that this does not overwrite all previously set
permissions for the member.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$modify_member_permissions(
  member,
  permissions = list(read = TRUE, copy = FALSE, write = FALSE, admin = FALSE)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{member}}{The Seven Bridges Platform username of the person
you want to modify permissions for or team ID or division ID
(for Enterprise users only) or object of class Member containing
member's ID.}

\item{\code{permissions}}{List of specific (or all) permissions you want to
update for the member of the volume.
Permissions include listing the contents of a volume, importing files
from the volume to the Platform, exporting files from the Platform to
the volume, and admin privileges.
It can contain fields: 'read', 'copy', 'write' and 'admin' with
logical fields - TRUE if certain permission is allowed to the user, or
FALSE if it's not.
Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{  permissions = list(read = TRUE, copy = TRUE, write = FALSE,
  admin = FALSE)
}\if{html}{\out{</div>}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Permission}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Modify volume member permissions
 volume_object$modify_member_permissions(
                    member = member,
                    permission = list(read = TRUE, copy = TRUE)
                  )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-list_imports"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-list_imports}{}}}
\subsection{Method \code{list_imports()}}{
This call lists import jobs initiated by particular user
from this volume.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$list_imports(
  project = NULL,
  state = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{project}}{String project id or Project object. List all volume
imports to this project. Optional.}

\item{\code{state}}{String. The state of the import job. Possible values are:
\itemize{
\item \code{PENDING}: the import is queued;
\item \code{RUNNING}: the import is running;
\item \code{COMPLETED}: the import has completed successfully;
\item \code{FAILED}: the import has failed.
}
Example: \code{state = c("RUNNING", "FAILED")}}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} containing list of
\code{\link{Import}} job objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List volume imports
 volume_object$list_imports(
                    project = project,
                    state = c("RUNNING", "FAILED")
                  )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-list_exports"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-list_exports}{}}}
\subsection{Method \code{list_exports()}}{
This call lists export jobs initiated by a user into this
volume.
Note that when you export a file from a project on the Platform into a
volume, you write to your cloud storage bucket.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$list_exports(
  state = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{The state of the export job. Possible values are:
\itemize{
\item \code{PENDING}: the export is queued;
\item \code{RUNNING}: the export is running;
\item \code{COMPLETED}: the export has completed successfully;
\item \code{FAILED}: the export has failed.
}
Example: \code{state = c("RUNNING", "FAILED")}}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} containing list of
\code{\link{Export}} job objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume is requested
volume_object <- Volume$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List volume exports
 volume_object$list_exports(state = c("RUNNING", "FAILED"))
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Volume-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Volume-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Volume$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
