% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local-moran-bv-impl.R
\name{local_moran_bv}
\alias{local_moran_bv}
\title{Compute the Local Bivariate Moran's I Statistic}
\usage{
local_moran_bv(x, y, nb, wt, nsim = 499)
}
\arguments{
\item{x}{a numeric vector of same length as \code{y}.}

\item{y}{a numeric vector of same length as \code{x}.}

\item{nb}{a neighbor list object for example as created by \code{st_contiguity()}.}

\item{wt}{a weights list as created by \code{st_weights()}.}

\item{nsim}{the number of simulations to run.}
}
\value{
a \code{data.frame} containing two columns \code{Ib} and \code{p_sim} containing the local bivariate Moran's I and simulated p-values respectively.
}
\description{
Given two continuous numeric variables, calculate the bivariate Local Moran's I.
}
\details{
The Bivariate Local Moran, like its global counterpart, evaluates the value
of x at observation i with its spatial neighbors' value of y. The value of \deqn{I_i^B} is just xi * Wyi. Or, in simpler words the local bivariate Moran is the result of multiplying x by the spatial lag of y. Formally it is defined as

\eqn{
I_i^B= cx_i\Sigma_j{w_{ij}y_j}
}
}
\examples{
x <- guerry_nb$crime_pers
y <- guerry_nb$wealth
nb <- guerry_nb$nb
wt <- guerry_nb$wt
local_moran_bv(x, y, nb, wt)
}
\references{
\href{https://geodacenter.github.io/workbook/6c_local_multi/lab6c.html#principle}{Local Spatial Autocorrelation (3): Multivariate Local Spatial Autocorrelation, Luc Anselin}
}
\seealso{
Other global_moran: 
\code{\link{global_moran}()},
\code{\link{global_moran_bv}()},
\code{\link{global_moran_perm}()},
\code{\link{global_moran_test}()}
}
\concept{global_moran}
