% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernelEstimator.R
\name{kernelEstimator}
\alias{kernelEstimator}
\title{Estimate a density on the unit interval or unit square via
local regression}
\usage{
kernelEstimator(
  x,
  transformation = "probit",
  eval.points = x,
  subsample = 1e+07,
  epsilon = 1e-15,
  epsilon.max = 0.999,
  maxk = 10000,
  trim = 1e-15,
  nn = NULL,
  ...
)
}
\arguments{
\item{x}{Either a vector or a 2-column matrix}

\item{transformation}{Either probit (default), complementary log-log, or
identity (not recommended)}

\item{eval.points}{Points at which to evaluate the estimate, default x}

\item{subsample}{Number of points that are randomly subsampled for
computing the fit; useful for computational efficiency and for ensuring
the density estimation does not run out of memory. NULL means no the
fit is performed on all points}

\item{epsilon}{How close values are allowed to come to 0}

\item{epsilon.max}{How close values are allowed to come to 1}

\item{maxk}{maxk argument passed to locfit}

\item{trim}{In one-dimensional fitting, the very edges often have high
variance. This parameter fixes the estimate on the intervals
(0, trim) and (1 - trim, 1).}

\item{nn}{nearest neighbor parameter}

\item{...}{additional arguments to be passed to lp in locfit, used only
if cv=FALSE}
}
\value{
A data frame containing:
\item{x1}{The first column in eval.points.}
\item{x2}{The second column in eval.points. Note this is not returned for one dimensional density estimation.}
\item{s1}{The transformed version of x1.}
\item{s2}{The transformed version of x2. Note this is not returned for one dimensional density estimation.}
\item{fx}{Density estimates on the original scale.}
\item{fs}{Density estimates on the transformed scale.}
}
\description{
This function is adapted from the fFDR package.
}
\details{
Provide density estimates that are needed by \code{sffdr}
}
