% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgo_set_gcs.R
\encoding{UTF-8}
\name{sgo_cart_lonlat}
\alias{sgo_cart_lonlat}
\title{Geodetic Coordinate System (GCS) in cartesian coordinates to polar
coordinates}
\usage{
sgo_cart_lonlat(x)
}
\arguments{
\item{x}{A \code{sgo_points} object with coordinates expressed in cartesian
coordinates}
}
\value{
An object of class \code{sgo_points} with polar coordinates (Longitude,
Latitude and Ellipsoid Height).
}
\description{
Converts a GCS expressed Earth-centered Earth-fixed (ECEF) cartesian
coordinate to Longitude and Latitude and Ellipsoid Height.
}
\details{
Currently converts from EPSGs \code{4936} and \code{4978} to \code{4937} and
\code{4979}
}
\examples{
p <- sgo_points(list(3487823.234, -305433.201, 5313739.634), epsg=4936)
p.xyz <- sgo_cart_lonlat(p) #Cartesian coordinates
}
\seealso{
\code{\link{sgo_points}}, \code{\link{sgo_bng_lonlat}}.
}
