% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgo_wgs84.R
\encoding{UTF-8}
\name{sgo_wgs84_en}
\alias{sgo_wgs84_en}
\title{WGS84 to Easting Northing (Pseudo - Mercator)}
\usage{
sgo_wgs84_en(x, to = 3857)
}
\arguments{
\item{x}{A \code{sgo_points} object describing a set of points in the
geodetic coordinate system EPSG=4326 or 4979.}

\item{to}{Numeric. Sets the \code{epsg} code of the destination Geodetic
Coordinate System. 3857 (WGS84) by default. And currently doesn't support any
other.}
}
\value{
An object of class \code{sgo_points} whose coordinates are defined as
Easting/Northing.
}
\description{
Converts WGS84 coordinates to Easting/Northing (Pseudo-Mercator)
}
\details{
This routine also accepts source data expressed in ETRS89 coordinates
(EPSG=4258 or 4937) as it is considered the difference between those two GCS
is far less than the accuracy available when working with Pseudo-Mercator
coordinates.

The results can be used in maps where Pseudo-Mercator coordinates are needed.
Usually, those include Google, Bing, OpenStreetMap and several other webmap
applications.
}
\examples{
p <- sgo_points(list(-3.9369, 56.1165), epsg=4326)
res <- sgo_wgs84_en(p)
}
\references{
IOGP Publication 373-7-2 - Geomatics Guidance Note number 7,
part 2 (October 2020). https://epsg.org/guidance-notes.html
}
\seealso{
\code{\link{sgo_points}}, \code{\link{sgo_en_wgs84}}.
}
