% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_field.R
\name{input_field}
\alias{input_field}
\title{Input Field Function}
\usage{
input_field(
  legend,
  labels,
  inputIds,
  widths = NULL,
  types = "text",
  error = FALSE,
  error_message = NULL
)
}
\arguments{
\item{legend}{Legend that goes above the fieldset}

\item{labels}{A list of labels for the text inputs}

\item{inputIds}{A list input slots that will be used to access the value.}

\item{widths}{control the size of the box based on number of characters
required.  Options are 30, 20, 10, 5, 4, 3, 2.  NULL will not limit the size}

\item{types}{text box types.  Will default to text.}

\item{error}{Whenever to icnlud error handling  Defaults to FALSE.}

\item{error_message}{Message to display on error.  Defaults to NULL}
}
\value{
a input field of html as a shiny object
}
\description{
This function inserts number of text inputs. Useful for addresses.
}
\examples{
if (interactive()) {

  ui <- fluidPage(
    # Required for error handling function
    shinyjs::useShinyjs(),
    shinyGovstyle::header(
      main_text = "Example",
      secondary_text = "User Examples",
      logo="shinyGovstyle/images/moj_logo.png"),
    shinyGovstyle::banner(
      inputId = "banner", type = "beta", 'This is a new service'),
    shinyGovstyle::gov_layout(size = "two-thirds",
      shinyGovstyle::input_field(
        legend ="List of three text boxes in a field",
        labels = c("Field 1", "Field 2", "Field 3"),
        inputIds = c("field1", "field2", "field3"),
        widths = c(30,20,10),
        error = TRUE),
     # Button to trigger error
     shinyGovstyle::button_Input(inputId = "submit", label = "Submit")
    ),
    shinyGovstyle::footer(full = TRUE)
  )

  server <- function(input, output, session) {
    # Trigger error on blank submit of field2
    observeEvent(input$submit, {
      if (input$field2 == ""){
        shinyGovstyle::error_on(inputId = "field2",
                                error_message = "Please complete")
      } else {
        shinyGovstyle::error_off(
          inputId = "field2")
      }
    })
  }
  shinyApp(ui = ui, server = server)
}
}
\keyword{field}
\keyword{input}
