% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toastify.R
\name{showToast}
\alias{showToast}
\title{Show a toast}
\usage{
showToast(
  session,
  input,
  id = NULL,
  text,
  type = "default",
  position = "top-right",
  transition = "slide",
  autoClose = 5000,
  hideProgressBar = FALSE,
  newestOnTop = FALSE,
  closeOnClick = TRUE,
  rtl = FALSE,
  pauseOnFocusLoss = TRUE,
  draggable = TRUE,
  draggableDirection = "x",
  draggablePercent = 80,
  pauseOnHover = TRUE,
  className = NULL,
  toastClassName = NULL,
  bodyClassName = NULL,
  progressClassName = NULL,
  style = NULL,
  Rcallback = function() {     NULL },
  JScallback = NULL
)
}
\arguments{
\item{session}{the Shiny \code{session} object}

\item{input}{the Shiny \code{input} object}

\item{id}{an id for the toast or \code{NULL} for automatic id; see details
for the use of this id}

\item{text}{the text displayed in the toast; this can be a character string,
an html element created with the \code{\link[htmltools:HTML]{HTML}}
function, or a \code{shiny.tag} object such as
\code{tags$span(style = "color:lime;", "Message")}}

\item{type}{toast type, one of \code{"info"}, \code{"success"},
\code{"warning"}, \code{"error"}, \code{"default"} or \code{"dark"}}

\item{position}{toast position, one of \code{"top-left"},
\code{"top-right"}, \code{"top-center"}, \code{"bottom-left"},
\code{"bottom-right"} or \code{"bottom-center"}}

\item{transition}{the transition effect, one of \code{"slide"},
\code{"zoom"}, \code{"flip"} or \code{"bounce"}}

\item{autoClose}{either a number, the time in ms to close the toast, or
\code{FALSE} to close the toast manually}

\item{hideProgressBar}{Boolean, whether to hide the progress bar}

\item{newestOnTop}{Boolean, whether to display newest toast on top}

\item{closeOnClick}{Boolean, whether to dismiss the toast on click}

\item{rtl}{Boolean, right to left}

\item{pauseOnFocusLoss}{Boolean, whether to pause the toast on focus loss}

\item{draggable}{Boolean, ability to drag the toast to remove it}

\item{draggableDirection}{\code{"x"} or \code{"y"}}

\item{draggablePercent}{the percentage of the width of the toast needed to
remove it by dragging}

\item{pauseOnHover}{Boolean, whether to pause the toast on hover}

\item{className}{name of a CSS class applied to the container}

\item{toastClassName}{name of a CSS class applied on the toast wrapper}

\item{bodyClassName}{name of a CSS class applied on the toast body}

\item{progressClassName}{name of a CSS class applied on the progress bar}

\item{style}{inline style applied to the container, e.g.
\code{list(boxShadow = "rgba(0, 0, 0, 0.56) 0px 22px 30px 4px")}}

\item{Rcallback}{a R function without arguments to be executed whenever the
toast is closed; alternatively, use the \code{id} argument (see details)}

\item{JScallback}{some JavaScript code given as a string to be executed
whenever the toast is closed, e.g. \code{'alert("The toast is closed")'}}
}
\value{
No return value, called for side effect.
}
\description{
Show a toast in a Shiny application.
}
\details{
\strong{Usage of the \code{id} argument.} If you provide a string
  to the \code{id} argument, say \code{"mytoast"}, the application will
  send the event \code{input[["mytoast_closed"]]} to the server whenever
  the toast closes; therefore you can listen to this event with an observer
  to perform an action whenever the toast closes.
}
\examples{
library(shiny)
library(shinyToastify)

ui <- fluidPage(
  useShinyToastify(),
  br(),
  actionButton("btn", "Show toast", class = "btn-primary btn-lg")
)

server <- function(input, output, session){

  toastTransitions <- c(
    "Zoom", "Bounce", "Flip", "Slide"
  )

  observeEvent(input[["btn"]], {

    toastTransition <- toastTransitions[1L + (input[["btn"]] \%\% 4L)]

    html <- HTML(
      '<span style="font-size: 30px; font-family: cursive;">',
      paste0(toastTransition, " transition"),
      '</span>',
    )

    showToast(
      session,
      input,
      text = html,
      type = "success",
      transition = tolower(toastTransition),
      autoClose = 3000,
      style = list(
        border = "4px solid crimson",
        boxShadow = "rgba(0, 0, 0, 0.56) 0px 22px 30px 4px"
      )
    )

  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
