% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpfiles.R
\docType{data}
\name{tabModules}
\alias{tabModules}
\title{Sample data for the shinymgr.sqlite table, "tabModules"}
\format{
A data frame with 10 observations on the following 4 variables.
}
\usage{
data(demo_data)
}
\description{
Sample data imported to the shinymgr SQLite database
 by the function \code{\link{shiny_db_populate}}.
}
\details{
-----------------------------------------------------------

New records to the "tabModules" table are added to the 
shinymgr.sqlite database 
via the "App Builder" interface within shinymgr's Developer section.
}
\section{Fields}{

\describe{
\item{\code{pkInstanceID}}{Auto-number primary key.}

\item{\code{fkTabName}}{References pkTabID from the "tabs" table.}

\item{\code{fkModuleName}}{References pkModuleID from the "module" table.}

\item{\code{modOrder}}{Integer. Gives the order in which a module appears in a tab.}
}}

\examples{

# read in the demo data
data(demo_data)

# look at the structure
str(tabModules)

}
\seealso{
Other data: 
\code{\link{appReports}},
\code{\link{appStitching}},
\code{\link{appTabs}},
\code{\link{apps}},
\code{\link{modFunctionArguments}},
\code{\link{modFunctionReturns}},
\code{\link{modPackages}},
\code{\link{modules}},
\code{\link{reports}},
\code{\link{tabs}}
}
\concept{data}
