% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_class_diag_plots.R
\name{plot_multiclass_pred_factorcol}
\alias{plot_multiclass_pred_factorcol}
\title{Visualizing the predicted probabilities vs. a factor variable for a classification
model}
\usage{
plot_multiclass_pred_factorcol(
  dat,
  y_name,
  factorcol,
  alpha = 1,
  size = 1,
  prob_scaling = FALSE,
  prob_eps = 0.001,
  source = NULL
)
}
\arguments{
\item{dat}{The predictions data frame in the \code{\link[=organize_data]{organize_data()}} result. Following
variables are required: \code{.outcome}, \code{.pred}, \code{.color}, and \code{.hover}.}

\item{y_name}{The y/response variable for the model.}

\item{factorcol}{The factor column to plot against the predicted probabilities.}

\item{alpha}{The opacity for the geom points.}

\item{size}{The size for the geom points.}

\item{prob_scaling}{The boolean to turn on or off the logit scale for probability.}

\item{prob_eps}{A small numerical constant to prevent division by zero.}

\item{source}{A character string of length 1 that matches the source argument
in event_data().}
}
\value{
A \code{\link[plotly:ggplotly]{plotly::ggplotly()}} object.
}
\description{
This function plots the predicted probabilities against a factor column based on
tidymodels results for a multi-class classification model.
}
\keyword{internal}
