% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/title.R
\name{flashing_window_title}
\alias{flashing_window_title}
\title{Create Flashing Browser Title}
\usage{
flashing_window_title(
  session = shiny::getDefaultReactiveDomain(),
  title = "Ready!",
  inactive_only = FALSE,
  revert_on_focus = inactive_only,
  revert_on_mousemove = TRUE,
  interval = 500,
  duration = 0
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to \code{shinyServer}.
Default is \code{getDefaultReactiveDomain()}.}

\item{title}{String to give the window title.}

\item{inactive_only}{Logical, whether or not the title should only change if the tab is not
active. Default is set to \code{FALSE}.}

\item{revert_on_focus}{Logical, should the title revert back to the original title when the tab is in
focus/active again? Only works when \code{inactive_only = TRUE}.}

\item{revert_on_mousemove}{Logical, should the title revert back to the original title when the mouse
is moved in the tab? Default is set to \code{TRUE}.}

\item{interval}{Time (in milliseconds) to flip between the original title and the new title.}

\item{duration}{Time (in milliseconds) to stop flashing the title. 0 (the default) means it will
flash indefinitely.}
}
\value{
The browser tab title will change between the original and newly specified title.
}
\description{
Alternate the text in the browser tab between the current text and the new specified text.
}
\note{
Add \code{use_shiny_title} within the UI for \code{flashing_window_title} to work.
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    title = "Initial Title",
    use_shiny_title(),
    actionButton("button", "Click me for a 10 second flashing title"),
    actionButton("button2", "Click me for a delayed flashing button")
  )

  server <- function(input, output, session) {
    observeEvent(input$button, {
      flashing_window_title(
        session, "--- Flash ---", revert_on_mousemove = FALSE, duration = 10000
      )
    })

    observeEvent(input$button2, {
      Sys.sleep(3)
      flashing_window_title(
        session, "Please Come Back", inactive_only = TRUE, interval = 1000
      )
    })
  }

  shinyApp(ui, server)
}

}
