% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_query_status.R
\name{get_query_status}
\alias{get_query_status}
\title{Get Query ID Status}
\usage{
get_query_status(
  query_run_id,
  api_key,
  api_url = "https://api-v2.flipsidecrypto.xyz/json-rpc"
)
}
\arguments{
\item{query_run_id}{queryRunId from `create_query_token()`, for token stored as `x`, use `x$result$queryRequest$queryRunId`}

\item{api_key}{Flipside Crypto ShroomDK API Key}

\item{api_url}{default to https://api-v2.flipsidecrypto.xyz/json-rpc but upgradeable for user.}
}
\value{
returns request content; for content `x`, use `x$result$queryRun$state` and `x$result$queryRun$errorMessage`. Expect one of
QUERY_STATE_READY, QUERY_STATE_RUNNING, QUERY_STATE_STREAMING_RESULTS, QUERY_STATE_SUCCESS, QUERY_STATE_FAILED, QUERY_STATE_CANCELED
}
\description{
Uses Flipside ShroomDK to access the status of a query run id from `create_query_token()`
}
\examples{
\dontrun{
query = create_query_token("SELECT * FROM ETHEREUM.CORE.FACT_TRANSACTIONS LIMIT 10000", api_key)
get_query_status(query$result$queryRequest$queryRunId, api_key)
}
}
