% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series.R
\name{getSeriesMetadata}
\alias{getSeriesMetadata}
\title{Query time series metadata}
\usage{
getSeriesMetadata(series, locale = "en")
}
\arguments{
\item{series}{A vector containing idSeries.}

\item{locale}{A string defining the language of the metadata. It can be obtained either in
English ("en") or Spanish ("es").}
}
\value{
A data.frame containing the required metadata.
}
\description{
Recovers metadata of the indicated time series (up to 100)
from \href{http://www.banxico.org.mx/SieInternet}{SIE}.
}
\details{
The series metadata are queried throught the \href{https://www.banxico.org.mx/SieAPIRest}{SIE API}.
This API requieres that every request is identified by a token. The token can be requested
\href{https://www.banxico.org.mx/SieAPIRest/service/v1/token}{here}.
Once the query token has been obtained and prior to use any function from this Package,
the token must be set in the current query session, using the function \code{\link{setToken}}.

The information can be obtained either in English ("en") or Spanish ("es"), defining the parameter locale.
By default the metadata are retrieved in English.
}
\examples{

\dontrun{
## You need a valid token to run the example
setToken(token)
series <- getSeriesMetadata(c("SF43718","SF46410","SF46407"))

serie <- getSeriesMetadata("SF43718")
}

}
