% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_boin_multi.R
\name{sim_boin_multi}
\alias{sim_boin_multi}
\title{Run BOIN Simulation for Multiple Scenarios}
\usage{
sim_boin_multi(
  scenarios,
  target,
  n_trials = 10000,
  n_cohort,
  cohort_size,
  p_saf = NULL,
  p_tox = NULL,
  n_earlystop = 18,
  cutoff_eli = 0.95,
  extrasafe = FALSE,
  offset = 0.05,
  n_earlystop_rule = "with_stay",
  titration = FALSE,
  min_mtd_sample = 1,
  boundMTD = FALSE,
  return_details = FALSE,
  verbose = FALSE,
  seed = 123
)
}
\arguments{
\item{scenarios}{List of scenario definitions. Each element must be a list containing:
\describe{
\item{\code{name}}{Character. Scenario identifier (e.g., "Scenario 1")}
\item{\code{p_true}}{Numeric vector. True toxicity probabilities for each dose}
}}

\item{target}{Numeric. Target toxicity probability (e.g., 0.30 for 30\%).}

\item{n_trials}{Numeric. Number of trials to simulate per scenario. Default is 10000.}

\item{n_cohort}{Numeric. Maximum number of cohorts per trial.}

\item{cohort_size}{Numeric vector or scalar. Patients per cohort.}

\item{p_saf}{Numeric. Highest toxicity probability deemed acceptable for safety.
Default is 0.6 * target. Used with p_tox for safety/efficacy dose identification.}

\item{p_tox}{Numeric. Lowest toxicity probability deemed unacceptable for toxicity.
Default is 1.4 * target. Used with p_saf for safety/efficacy dose identification.}

\item{n_earlystop}{Numeric. Sample size triggering early stopping. Default is 18.}

\item{cutoff_eli}{Numeric. Cutoff probability for dose elimination. Default is 0.95.}

\item{extrasafe}{Logical. Apply extra safety stopping rule at lowest dose. Default is FALSE.}

\item{offset}{Numeric. Offset for safety cutoff when extrasafe = TRUE. Default is 0.05.}

\item{n_earlystop_rule}{Character. Early stopping rule: "with_stay" or "simple". Default is "with_stay".}

\item{titration}{Logical. Perform accelerated dose titration phase. Default is FALSE.}

\item{min_mtd_sample}{Numeric. Minimum patients required for MTD consideration. Default is 1.}

\item{boundMTD}{Logical. Impose constraint that MTD's isotonic estimate <= lambda_d. Default is FALSE.}

\item{return_details}{Logical. If TRUE, return detailed trial-level results. Default is FALSE.}

\item{verbose}{Logical. If TRUE, print progress messages to console. If FALSE, run silently. Default is FALSE.}

\item{seed}{Numeric. Random seed for reproducibility. Default is 123.}
}
\value{
A list with class "boin_multi_summary" containing:
\item{results_by_scenario}{List of simulation results for each scenario}
\item{combined_summary_df}{Data frame with aggregated operating characteristics}
\item{scenario_names}{Character vector of scenario identifiers}
\item{n_doses}{Numeric. Number of doses evaluated}
\item{call}{The function call}
}
\description{
Execute BOIN trial simulations across multiple dose-toxicity scenarios and
compute operating characteristics for each scenario. Results are aggregated
into a combined summary table suitable for protocol development and reports.
}
\details{
Progress messages are printed to console only if verbose = TRUE.
For large-scale studies (50+ scenarios), computation time may be substantial.
}
\examples{
\donttest{
scenarios <- list(
  list(name = "Scenario 1", p_true = c(0.05, 0.10, 0.20, 0.30, 0.45)),
  list(name = "Scenario 2", p_true = c(0.10, 0.15, 0.30, 0.45, 0.60))
)

# Silent mode (default)
result <- sim_boin_multi(
  scenarios = scenarios,
  target = 0.30,
  n_trials = 10000,
  n_cohort = 48,
  cohort_size = 3,
  seed = 123
)

# With progress messages
result_verbose <- sim_boin_multi(
  scenarios = scenarios,
  target = 0.30,
  n_trials = 10000,
  n_cohort = 48,
  cohort_size = 3,
  verbose = TRUE,
  seed = 123
)
}

}
\references{
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I Clinical
Trials. Journal of the Royal Statistical Society: Series C, 64, 507-523.
}
