% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EffRSparse.R
\name{net.as}
\alias{net.as}
\title{Network format converter}
\usage{
net.as(network, net.to = "E_List", directed = FALSE)
}
\arguments{
\item{network}{Weighted adjacency matrix, weighted \code{igraph} network, or edge list formatted | n1 | n2 | weight | with colnames \code{c("n1", "n2", "weight")}.}

\item{net.to}{Specifics to what format the imputed network is to be converted: \cr
(1) 'E_List' convert to an edge list of the format | n1 | n2 | weight | with colnames \code{c("n1", "n2", "weight")}.\cr
(2) 'Adj' convert to a weighted adjacency matrix.\cr
(3) 'igraph' convert to a weighted igraph object.}

\item{directed}{If \code{TRUE}, specifies that the inputted network is directed. Default is \code{FALSE}.}
}
\value{
A network of the format specified by \code{net.to}.
}
\description{
Convert a network in weighted adjacency matrix, edge list, or igraph to a weighted adjacency matrix, edge list, or igraph format.
}
\author{
Alexander Mercier
}
