% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prepare_design}
\alias{prepare_design}
\title{Prepare design for experiment from a list of simulation parameter}
\usage{
prepare_design(option_list, tabular = TRUE)
}
\arguments{
\item{option_list}{A list of options that is to be parsed}

\item{tabular}{logical if output is needed in tabular form or list format}
}
\value{
A list of parsed parameters for simulatr
}
\description{
Prepare design for experiment from a list of simulation parameter
}
\examples{
opts <- list(
  n = rep(100, 2),
  p = c(20, 40),
  q = c("5, 5, 4",
        "10, 5, 5"),
  m = c(5, 5),
  relpos = c("1; 2, 4; 3",
             "1, 2; 3, 4; 5"),
  gamma = c(0.2, 0.4),
  R2 = c("0.8, 0.9, 0.7",
         "0.6, 0.8, 0.7"),
  ypos = c("1, 4; 2, 5; 3",
           "1; 2, 4; 3, 5"),
  ntest = rep(1000, 2)
)
design <- prepare_design(opts)
design
}
