% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tabulate_eval}
\alias{tabulate_eval}
\title{Make a table of a metric for each pair of models and methods}
\usage{
tabulate_eval(
  object,
  metric_name,
  method_names = NULL,
  caption = NULL,
  center_aggregator = NULL,
  spread_aggregator = NULL,
  se_format = c("Paren", "PlusMinus", "None"),
  output_type = "latex",
  format_args = list(nsmall = 0, digits = NULL, scientific = FALSE),
  na_string = "--",
  bold = c("None", "Smallest", "Largest")
)
}
\arguments{
\item{object}{an object of class \code{\linkS4class{Simulation}},
\code{\linkS4class{Evals}}, or \code{listofEvals}.
Each evals object should just differ by model_name.}

\item{metric_name}{the name of a metric to tabulate.  Must be scalar valued.}

\item{method_names}{character vector indicating methods to include in table.
If NULL, then will include all methods found in object's evals.}

\item{caption}{caption of plot. If NULL, then default caption used; if FALSE
then no caption (and returns tabular without table).}

\item{center_aggregator}{When NULL (which is default), the sample mean
aggregator is used.  User can write specialized aggregators (see
definition of class \code{\linkS4class{Aggregator}}) as necessary,
for example, when the evaluated metric is not scalar-valued.}

\item{spread_aggregator}{When NULL (which is default), the standard error 
of the sample mean is used.  User can write specialized aggregators (see
definition of class \code{\linkS4class{Aggregator}}) as necessary,
for example, when the evaluated metric is not scalar-valued. Set
\code{spread_aggregator} to \code{NA} to hide error bars.}

\item{se_format}{format of the standard error}

\item{output_type}{see \code{\link[knitr]{kable}}'s argument format for options.
Default is "latex" but other options include "html" and "markdown"}

\item{format_args}{arguments to pass to the function \code{\link{format}}}

\item{na_string}{what to write in table in place of NA}

\item{bold}{puts in bold the value that is smallest/largest for each model}
}
\description{
Each row of the table corresponds to a different model and each column
to a different method.  The metric must be a scalar.  The way in which
standard error is shown (or not shown) is controlled by \code{se_format}.
}
\details{
Uses \code{knitr}'s function \code{kable} to put table in various formats,
including latex, html, markdown, etc.
}
\examples{
\dontrun{
 # suppose previously we had run the following:
 sim <- new_simulation(name = "normal-example",
                       label = "Normal Mean Estimation",
                       dir = tempdir()) \%>\%
   generate_model(make_my_example_model,
                  n = list(10, 20, 30),
                  vary_along = "n") \%>\%
   simulate_from_model(nsim = 50, index = 1:3) \%>\%
   run_method(my_example_method) \%>\%
   evaluate(my_example_loss)
   # then we could plot this
   tabulate_eval(sim, "myloss")
 }
}
