% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_dgp.R
\name{simulation_dgp}
\alias{simulation_dgp}
\title{Simulating observations from the data-generating process considered in Lee and Ng (2022)}
\usage{
simulation_dgp(n, d, hetero = FALSE)
}
\arguments{
\item{n}{sample size}

\item{d}{dimension of regressors from a multivariate normal distribution}

\item{hetero}{TRUE if the conditional variance of the error term is heteroskedastic and
FALSE if it is homoskedastic  (default: FALSE)}
}
\value{
An S3 object has the following elements.
\item{Y}{n observations of outcomes}
\item{X}{n times d matrix of regressors}
\item{beta}{d dimensional vector of coefficients}
}
\description{
Simulates observations from the data-generating process considered in Lee and Ng (2022)
}
\examples{
  data <- simulation_dgp(100, 5, hetero = TRUE)
  y <- data$Y
  x <- data$X
  model  <- lm(y ~ x) 

}
\references{
Lee, S. and Ng, S. (2022). "Least Squares Estimation Using Sketched Data with Heteroskedastic Errors," arXiv:2007.07781.
}
