% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slanter.R
\name{slanted_orders}
\alias{slanted_orders}
\title{Compute rows and columns orders which move high values close to the diagonal.}
\usage{
slanted_orders(
  data,
  order_rows = TRUE,
  order_cols = TRUE,
  squared_order = TRUE,
  same_order = FALSE,
  discount_outliers = TRUE,
  max_spin_count = 10
)
}
\arguments{
\item{data}{A rectangular matrix containing non-negative values.}

\item{order_rows}{Whether to reorder the rows.}

\item{order_cols}{Whether to reorder the columns.}

\item{squared_order}{Whether to reorder to minimize the l2 norm (otherwise minimizes the l1 norm).}

\item{same_order}{Whether to apply the same order to both rows and columns.}

\item{discount_outliers}{Whether to do a final order phase discounting outlier values far from the diagonal.}

\item{max_spin_count}{How many times to retry improving the solution before giving up.}
}
\value{
A list with two keys, \code{rows} and \code{cols}, which contain the order.
}
\description{
For a matrix expressing the cross-similarity between two (possibly different) sets of entities,
this produces better results than clustering (e.g. as done by \code{pheatmap}). This is because
clustering does not care about the order of each two sub-partitions. That is, clustering is as
happy with \code{((2, 1), (4, 3))} as it is with the more sensible \code{((1, 2), (3, 4))}. As a
result, visualizations of similarities using naive clustering can be misleading.
}
\examples{
slanter::slanted_orders(cor(t(mtcars)))
}
