% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_table.R
\name{.cache_query_result}
\alias{.cache_query_result}
\title{Cache a remote query result to a local DuckDB database}
\usage{
.cache_query_result(
  source_conn_name,
  source_query,
  dest_table_name,
  overwrite = TRUE,
  config_path = "~/snowquery_creds.yaml"
)
}
\arguments{
\item{source_conn_name}{The name of the remote database connection in your snowquery_creds.yaml file.}

\item{source_query}{The SQL query to execute on the remote source.}

\item{dest_table_name}{The name of the table to be created in the local DuckDB database.}

\item{overwrite}{A boolean (TRUE/FALSE) to control whether to overwrite the destination table if it already exists.}

\item{config_path}{The path to your snowquery_creds.yaml file.}
}
\value{
Invisibly returns a confirmation message.
}
\description{
Efficiently streams the result of a query from a remote source (Snowflake, Redshift, Postgres)
to a local DuckDB file. This method is memory-efficient and suitable for very large query results as it
streams data without loading the entire result set into R's memory.
}
