% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrices.R
\name{dmatrix}
\alias{dmatrix}
\title{Sij dyadic relationship matrix}
\usage{
dmatrix(smatrix)
}
\arguments{
\item{smatrix}{sociomatrix}
}
\value{
Dyadic matrix
}
\description{
Function to obtain the Sij dyadic dominance relationship from an sociomatrix.
}
\details{
The dyadic relationship is obtained by the following expression:
Sij = (Xij - Xji) / (|Xij - Xji|), where Sij is the social status of the ith animal relative
to the jth animal; Xij is the number of times the animal i won the animal j;
Xji is the number of times the animal j won the animal i.
}
\examples{
           
x <- matrix(c(0,0,1,0,0,1,0,0,2,0,0,0,0,1,0,0,0,1,0,0,2,
             0,0,0,0,1,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,
             1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
             nrow=8,byrow=TRUE,)
colnames(x) <- c(1,2,3,4,5,6,8,9)

rownames(x) <- c(1,2,3,4,5,6,8,9)

dyadic <- dmatrix(x)

print(dyadic)
                                                                                   
}
\references{
Kondo, S., & Hurnik, J. F. (1990). Stabilization of social hierarchy in dairy cows.
Applied Animal Behaviour Science, 27(4), 287-297.
}
\author{
Julia P. S. Valente, Matheus Deniz, Karolini T. de Sousa.
}
