% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_function.R
\name{correction_function}
\alias{correction_function}
\title{A function to correct stoichiometry dynamically}
\usage{
correction_function(
  biomasses,
  cij,
  CN,
  p,
  a,
  canIMM,
  dietlimits,
  diet_correct = TRUE,
  Conly = FALSE,
  Immobilizationlimit = Inf
)
}
\arguments{
\item{biomasses}{A vector of biomasses.}

\item{cij}{The consumption matrix from Cijfcn}

\item{CN}{A vector of C:N ratios.}

\item{p}{A vector of production efficiency.}

\item{a}{A vector of assimilation efficiency.}

\item{canIMM}{A Boolean vector of whether the nodes can immobilize nitrogen.}

\item{dietlimits}{The diet limits matrix for the stoichiometry correction (proportion of diet)?}

\item{diet_correct}{Boolean: Does the organism correct it's diet?}

\item{Conly}{Boolean: Is the model meant for carbon only?}

\item{Immobilizationlimit}{This is the limit of the amount of nitrogen the food web can immobilize nitrogen (NOT PLANTS). This will impact the calculations of inorganic nitrogen dynamics.}
}
\value{
Returns the consumption rates (FMAT) and production efficiencies (p).
}
\description{
A function to correct stoichiometry dynamically
}
\details{
This function takes inputs from the ODE and outputs corrected consumption rates.
The key difference from 'corrstoich' is that the prey DO NOT correct their feeding rates to compensate for higher consumption from the predators, so the system can leave equilibrium if a diet shift occurs.
}
