/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class SQLUtils$ {
    public static SQLUtils$ MODULE$;

    static {
        new SQLUtils$();
    }

    public Dataset<Row> createDataFrame(SparkSession sc, RDD<InternalRow> catalystRows, StructType schema) {
        Dataset sdf = sc.internalCreateDataFrame(catalystRows, schema, sc.internalCreateDataFrame$default$3());
        return sdf;
    }

    public StructType createStructType(Seq<StructField> fields) {
        return StructType$.MODULE$.apply(fields);
    }

    public DataType getSQLDataType(String dataType) {
        Regex RegexArray = new StringOps(Predef$.MODULE$.augmentString("\\Aarray<(.+)>\\Z")).r((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"elemType"}));
        Regex RegexMap = new StringOps(Predef$.MODULE$.augmentString("\\Amap<(.+),(.+)>\\Z")).r((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyType", "valueType"}));
        Regex RegexStruct = new StringOps(Predef$.MODULE$.augmentString("\\Astruct<(.+)>\\Z")).r((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fieldsStr"}));
        Regex RegexStructField = new StringOps(Predef$.MODULE$.augmentString("\\A(.+):(.+)\\Z")).r((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fieldName", "fieldType"}));
        String string = dataType;
        if ("BooleanType".equals(string)) {
            return BooleanType$.MODULE$;
        }
        if ("ByteType".equals(string)) {
            return ByteType$.MODULE$;
        }
        if ("IntegerType".equals(string)) {
            return IntegerType$.MODULE$;
        }
        if ("LongType".equals(string)) {
            return LongType$.MODULE$;
        }
        if ("FloatType".equals(string)) {
            return FloatType$.MODULE$;
        }
        if ("DoubleType".equals(string)) {
            return DoubleType$.MODULE$;
        }
        if ("StringType".equals(string)) {
            return StringType$.MODULE$;
        }
        if ("TimestampType".equals(string)) {
            return TimestampType$.MODULE$;
        }
        if ("DateType".equals(string)) {
            return DateType$.MODULE$;
        }
        if ("BinaryType".equals(string)) {
            return BinaryType$.MODULE$;
        }
        if ("byte".equals(string)) {
            return ByteType$.MODULE$;
        }
        if ("integer".equals(string)) {
            return IntegerType$.MODULE$;
        }
        if ("integer64".equals(string)) {
            return LongType$.MODULE$;
        }
        if ("float".equals(string)) {
            return FloatType$.MODULE$;
        }
        if ("double".equals(string)) {
            return DoubleType$.MODULE$;
        }
        if ("numeric".equals(string)) {
            return DoubleType$.MODULE$;
        }
        if ("long".equals(string)) {
            return LongType$.MODULE$;
        }
        if ("character".equals(string)) {
            return StringType$.MODULE$;
        }
        if ("factor".equals(string)) {
            return StringType$.MODULE$;
        }
        if ("string".equals(string)) {
            return StringType$.MODULE$;
        }
        if ("binary".equals(string)) {
            return BinaryType$.MODULE$;
        }
        if ("raw".equals(string)) {
            return BinaryType$.MODULE$;
        }
        if ("logical".equals(string)) {
            return BooleanType$.MODULE$;
        }
        if ("boolean".equals(string)) {
            return BooleanType$.MODULE$;
        }
        if ("POSIXct".equals(string)) {
            return TimestampType$.MODULE$;
        }
        if ("POSIXlt".equals(string)) {
            return TimestampType$.MODULE$;
        }
        if ("timestamp".equals(string)) {
            return TimestampType$.MODULE$;
        }
        if ("Date".equals(string)) {
            return DateType$.MODULE$;
        }
        if ("date".equals(string)) {
            return DateType$.MODULE$;
        }
        if ("spark_apply_binary_result".equals(string)) {
            return ArrayType$.MODULE$.apply((DataType)BinaryType$.MODULE$);
        }
        Option option = RegexArray.unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String elemType = (String)((LinearSeqOptimized)option.get()).apply(0);
            return ArrayType$.MODULE$.apply(this.getSQLDataType(elemType));
        }
        Option option2 = RegexMap.unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
            String keyType = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String valueType = (String)((LinearSeqOptimized)option2.get()).apply(1);
            String string2 = keyType;
            String string3 = "string";
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                String string4 = keyType;
                String string5 = "character";
                if (string4 == null ? string5 != null : !string4.equals(string5)) {
                    throw new IllegalArgumentException("Key type of a map must be string or character");
                }
            }
            return MapType$.MODULE$.apply(this.getSQLDataType(keyType), this.getSQLDataType(valueType));
        }
        Option option3 = RegexStruct.unapplySeq((CharSequence)string);
        if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0) {
            String fieldsStr = (String)((LinearSeqOptimized)option3.get()).apply(0);
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(fieldsStr), fieldsStr.length() - 1) == ',') {
                throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(dataType).toString());
            }
            String[] fields = fieldsStr.split(",");
            StructField[] structFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)field -> {
                String string = field;
                Option option = RegexStructField.unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                    String fieldName = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String fieldType = (String)((LinearSeqOptimized)option.get()).apply(1);
                    return MODULE$.createStructField(fieldName, fieldType, true);
                }
                throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(dataType).toString());
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            return this.createStructType((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])structFields));
        }
        throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(dataType).toString());
    }

    public StructField createStructField(String name, String dataType, boolean nullable) {
        DataType dtObj = this.getSQLDataType(dataType);
        return new StructField(name, dtObj, nullable, StructField$.MODULE$.apply$default$4());
    }

    public StructField createStructField(String name, StructType struct) {
        return new StructField(name, (DataType)struct, true, StructField$.MODULE$.apply$default$4());
    }

    public StructField[] createStructFields(Seq<Object> specs) {
        return (StructField[])((TraversableOnce)specs.map((Function1 & Serializable & scala.Serializable)x -> {
            Object[] spec = (Object[])x;
            return MODULE$.createStructField((String)spec[0], (String)spec[1], BoxesRunTime.unboxToBoolean((Object)spec[2]));
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class));
    }

    private SQLUtils$() {
        MODULE$ = this;
    }
}

