% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latitude.R
\name{latmask}
\alias{latmask}
\title{Latitude mask for polar raster}
\usage{
latmask(x, latitude = 0, southern = TRUE, trim = FALSE, ...)
}
\arguments{
\item{x}{a raster layer}

\item{latitude}{maximum latitude  (effectively a minimum latitude if \code{southern = FALSe})}

\item{southern}{flag for whether south-polar context is used, default is \code{TRUE}}

\item{trim}{if \code{TRUE} runs \code{raster::trim} on the result, to remove \code{NA} margin}

\item{...}{ignored currently}
}
\value{
RasterLayer
}
\description{
Mask out values based on latitude for a raster. This works by finding all cells at
latitudes less than \code{latitude} and setting them to missing. If \code{southern = FALSE}
the inequality is reversed, and all cells at latitudes greater than \code{latitude} are
masked out.
}
\details{
The \code{trim} option allows for the result to be reduced to the common bounding box
within which any row or column has a non-missing value.
}
\examples{
 
library(raster)
plot(latmask(ice, -60))
plot(latmask(ice, -60, trim = TRUE))
ice[!ice > 0] <- NA
plot(ice)
plot(latmask(ice, -55, trim = TRUE))
}
\seealso{
\link[raster:trim]{raster::trim}, \link{latitudecircle}
}
