% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solar.R
\name{calc_daily_solar}
\alias{calc_daily_solar}
\title{Calculate daily solar radiation fluxes}
\usage{
calc_daily_solar(
  lat,
  n,
  elv = 0,
  y = 0,
  sf = 1,
  tc = 23,
  ke = 0.0167,
  keps = 23.44,
  komega = 283,
  kA = 107,
  kalb_sw = 0.17,
  kalb_vis = 0.03,
  kb = 0.2,
  kc = 0.25,
  kd = 0.5,
  kfFEC = 2.04,
  kGsc = 1360.8
)
}
\arguments{
\item{lat}{double, decimal degrees.}

\item{n}{double, day of year.}

\item{elv}{double, elevation, m A.S.L.
Default: \eqn{0}.}

\item{y}{double, year.
Default: \eqn{0}.}

\item{sf}{double, fraction of sunshine hours.
Default: \eqn{1}.}

\item{tc}{double, mean daily air temperature, degrees C.
Default: \eqn{23.0}.}

\item{ke}{double, eccentricity of earth's orbit.
Default: \eqn{0.01670}, 2000CE (Berger, 1978).}

\item{keps}{double, obliquity of earth's elliptic.
Default: \eqn{23.44}, 2000CE (Berger, 1978).}

\item{komega}{double, lon. of perihelion, degrees
Default: \eqn{283}, 2000CE (Berger, 1978).}

\item{kA}{double, empirical constant, degrees Celsius.
Default: \eqn{107} (Monteith and Unsworth, 1990).}

\item{kalb_sw}{double, shortwave albedo.
Default: \eqn{0.17} (Federer, 1968).}

\item{kalb_vis}{double, visible light albedo.
Default: \eqn{0.03} (Sellers, 1985).}

\item{kb}{double, empirical constant.
Default: \eqn{0.20} (Linacre, 1968).}

\item{kc}{double, cloudy transmittivity.
Default: \eqn{0.25} (Linacre, 1968).}

\item{kd}{double, angular coefficient of transmittivity.
Default: \eqn{0.50} (Linacre, 1968).}

\item{kfFEC}{double, flux-to-energy conversion, umol/J.
Default: \eqn{2.04} (Meek et al., 1984).}

\item{kGsc}{double, solar constant, W/m^2.
Default: \eqn{1360.8} (Kopp and Lean, 2011).}
}
\value{
Returns a \code{list} object with the following variables:
\itemize{
\item nu_deg ............ true anomaly, degrees
\item lambda_deg ........ true longitude, degrees
\item dr ................ distance factor, unitless
\item delta_deg ......... declination angle, degrees
\item hs_deg ............ sunset angle, degrees
\item ra_j.m2 ........... daily extraterrestrial radiation, J/m^2
\item tau ............... atmospheric transmittivity, unitless
\item ppfd_mol.m2 ....... daily photosyn. photon flux density, mol/m^2
\item hn_deg ............ net radiation hour angle, degrees
\item rn_j.m2 ........... daily net radiation, J/m^2
\item rnn_j.m2 .......... daily nighttime net radiation, J/m^2
}
}
\description{
This function calculates daily solar radiation fluxes.
}
\examples{
solar <- splash::calc_daily_solar(lat = 37.7,
                                  n = 172,
                                  elv = 142,
                                  y = 2000,
                                  sf = 1,
                                  tc = 23.0)
cat(sprintf("Solar values:\n"))
cat(sprintf("  kn: \%d\n", solar$kN))
cat(sprintf("  nu: \%0.6f degrees\n", solar$nu_deg))
cat(sprintf("  lambda: \%0.6f degrees\n", solar$lambda_deg))
cat(sprintf("  rho: \%0.6f\n", solar$rho))
cat(sprintf("  dr: \%0.6f\n", solar$dr))
cat(sprintf("  delta: \%0.6f degrees\n", solar$delta_deg))
cat(sprintf("  ru: \%0.6f\n", solar$ru))
cat(sprintf("  rv: \%0.6f\n", solar$rv))
cat(sprintf("  rw: \%0.6f\n", solar$rw))
cat(sprintf("  hs: \%0.6f degrees\n", solar$hs_deg))
cat(sprintf("  hn: \%0.6f degrees\n", solar$hn_deg))
cat(sprintf("  tau_o: \%0.6f\n", solar$tau_o))
cat(sprintf("  tau: \%0.6f\n", solar$tau))
cat(sprintf("  Qn: \%0.6f mol/m^2\n", solar$ppfd_mol.m2))
cat(sprintf("  Rnl: \%0.6f w/m^2\n", solar$rnl_w.m2))
cat(sprintf("  Ho: \%0.6f MJ/m^2\n", (1.0e-6) * solar$ra_j.m2))
cat(sprintf("  Hn: \%0.6f MJ/m^2\n", (1.0e-6) * solar$rn_j.m2))
cat(sprintf("  Hnn: \%0.6f MJ/m^2\n", (1.0e-6) * solar$rnn_j.m2))
}
\references{
Berger, A.L., 1978. Long-term variations of daily insolation and Quaternary
climatic changes. Journal of Atmospheric Sciences, 35(12), pp.2362-2367.
\doi{10.1175/1520-0469(1978)035<2362:LTVODI>2.0.CO;2}

Federer, C.A., 1968. Spatial variation of net radiation, albedo and surface
temperature of forests. Journal of Applied Meteorology and Climatology, 7(5),
pp.789-795. \doi{10.1175/1520-0450(1968)007<0789:SVONRA>2.0.CO;2}

Kopp, G. and Lean, J.L., 2011. A new, lower value of total solar irradiance:
Evidence and climate significance. Geophys. Res. Lett. 38, L01706.
\doi{10.1029/2010GL045777}

Linacre, E.T., 1968. Estimating the net-radiation flux. Agricultural
meteorology, 5(1), pp.49-63. \doi{10.1016/0002-1571(68)90022-8}

Meek, D.W., Hatfield, J.L., Howell, T.A., Idso, S.B. and Reginato, R.J.,
1984. A generalized relationship between photosynthetically active radiation
and solar radiation 1. Agronomy journal, 76(6), pp.939-945.
\doi{10.2134/agronj1984.00021962007600060018x}

Monteith, J., and Unsworth, M., 1990. Principles of Environmental Physics,
Butterworth-Heinemann, Oxford.

Sellers, P.J., 1985. Canopy reflectance, photosynthesis and transpiration,
International Journal of Remote Sensing, 6:8, 1335-1372,
\doi{10.1080/01431168508948283}
}
