% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fire_mov.R
\name{get_fire_mov}
\alias{get_fire_mov}
\title{Calculation of the fire movement}
\usage{
get_fire_mov(result, cluster, step = 1, method = "mean")
}
\arguments{
\item{result}{\code{spotoroo} object. A result of a call to \code{\link[=hotspot_cluster]{hotspot_cluster()}}.}

\item{cluster}{Integer. The membership label of the cluster.}

\item{step}{Integer (>0). Step size used in the calculation of the
fire movement.}

\item{method}{Character. Either "mean" or "median",
method of the calculation of
the centre of the fire.}
}
\value{
A data.frame. The fire movement.
\itemize{
\item \code{membership} : Membership labels.
\item \code{lon} : Longitude of the centre of the fire.
\item \code{lat} : Latitude of the centre of the fire.
\item \code{timeID} : Time indexes.
\item \code{obsTime} : Observed time (approximated).
\item \code{ignition} : Whether or not it is a ignition point.
}
}
\description{
This function calculates the movement of a single fire per \code{step} time
indexes. It collects hot spots per \code{step} time indexes, then
takes the mean or median of the longitude and latitude as the centre of the
fire.
}
\examples{

\donttest{

  # Time consuming functions (>5 seconds)


  # Get clustering results
  result <- hotspot_cluster(hotspots,
                          lon = "lon",
                          lat = "lat",
                          obsTime = "obsTime",
                          activeTime = 24,
                          adjDist = 3000,
                          minPts = 4,
                          minTime = 3,
                          ignitionCenter = "mean",
                          timeUnit = "h",
                          timeStep = 1)

  # Get fire movement of the first cluster
  mov1 <- get_fire_mov(result, cluster = 1, step = 3, method = "mean")
  mov1

  # Get fire movement of the second cluster
  mov2 <- get_fire_mov(result, cluster = 2, step = 6, method = "median")
  mov2
}


}
