% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dist_cstep}
\alias{dist_cstep}
\title{Computes Mahalanobis Distances for a Given Set of H-Subsets}
\usage{
dist_cstep(init, i, lambda, weights)
}
\arguments{
\item{init}{A list of items where each item contains the following elements:
\itemize{
  \item \code{mX} A matrix of observations (one column per observation).
  \item \code{vMu} A vector of means.
  \item \code{mS} A covariance matrix of the observations in \code{mX}.
}}

\item{i}{An integer index specifying which item from the \code{init} list to use.}

\item{lambda}{A numeric value representing the weight for the covariance matrix of the current item.}

\item{weights}{A matrix of weights where each element \code{weights(i, j)} specifies the weight of the \code{j}-th item for the \code{i}-th item.}
}
\value{
A numeric vector of distances for each observation in the centered matrix.
}
\description{
This function calculates the Mahalanobis distances for a set of observations
by centering them with the mean vector and using a covariance matrix computed
as a weighted combination of the covariance matrix of the current item and
the covariance matrices of its neighbors.
}
\details{
The Mahalanobis distances are computed using the covariance matrix,
which is a weighted combination of the current item's covariance matrix and
those of its neighbors. The covariance matrix is smoothed using the parameter
\code{lambda} and the distances are computed as \code{(x_centered^T * Cov_matrix_chol_inv * x_centered)} for each observation.
}
\keyword{internal}
