% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stIHC.R
\name{stIHC}
\alias{stIHC}
\title{Spatial Transcriptomics Iterative Hierarchical Clustering}
\usage{
stIHC(data)
}
\arguments{
\item{data}{data frame with columns \code{x}, \code{y} for spatial
coordinates and subsequent columns containing observations.}
}
\value{
A list with elements:
\item{label}{Vector of cluster labels.}
\item{mean_clusters_mat}{Matrix of cluster means.}
\item{clusters}{List of matrices, each matrix contains the observations belonging to that cluster.}
}
\description{
Spatial Transcriptomics Iterative Hierarchical Clustering
}
\examples{
\donttest{
## Load example data within the package
rds_path <- system.file("extdata", "spatial_data.rds", package = "stIHC")
example_data <- readRDS(rds_path)

## Run stIHC
stihc = stIHC(example_data)

## Inspect cluster assignments
table(stihc$label)
}
}
