% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_functions.R
\name{ssc}
\alias{ssc}
\title{Calculate the shift-and shape-sensitive congruence (SSC) between two matrices}
\usage{
ssc(mat1, mat2, tcc = FALSE)
}
\arguments{
\item{mat1}{matrix}

\item{mat2}{matrix}

\item{tcc}{if set TRUE, TCC is returned instead}
}
\value{
table containing pairwise SCC of matrices columns
}
\description{
Please see details in:
U.J. Wünsch, R. Bro, C.A. Stedmon, P. Wenig, K.R. Murphy, Emerging patterns in the global distribution of dissolved matter fluorescence, Anal. Methods, 11 (2019), pp. 888-893
}
\examples{
pf_models <- pf3
mat1 <- pf_models[[1]][[2]]
mat2 <- pf_models[[2]][[2]]

## calculate SSC
ssc(mat1,mat2)

## calculate TCC
ssc(mat1,mat2, tcc = TRUE)

}
