% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_paths_stages.R
\name{get_stage}
\alias{get_stage}
\alias{get_path}
\title{Get stage or path}
\usage{
get_stage(object, path)

get_path(object, var, stage)
}
\arguments{
\item{object}{an object of class \code{sevt}.}

\item{path}{character vector, the path from root or
a two dimensional array where each row is a path
from root.}

\item{var}{character, one of the variable in
the staged tree.}

\item{stage}{character vector, the name
of the stages for which the paths should be
returned.}
}
\value{
\code{get_stage} returns
the stage name(s)  for given path(s).

\code{get_path} returns a
data.frame containing the paths
corresponding to the given stage(s).
}
\description{
Utility functions to obtain stages from paths and
paths from stages.
}
\examples{
model <- stages_fbhc(full(PhDArticles))
get_stage(model, c("0", "male"))
paths <- expand.grid(model$tree[2:1])[, 2:1]
get_stage(model, paths)
get_path(model, "Kids", "5")
get_path(model, "Gender", "2")
get_path(model, "Kids", c("5", "6"))
}
