% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stages.R
\name{stages}
\alias{stages}
\alias{stages.sevt}
\alias{print.sevt.stgs}
\alias{stages<-}
\alias{[.sevt.stgs}
\alias{[<-.sevt.stgs}
\alias{[[.sevt.stgs}
\alias{[[<-.sevt.stgs}
\title{The stages of a staged event tree}
\usage{
stages(object)

\method{stages}{sevt}(object)

\method{print}{sevt.stgs}(x, ..., max = 5)

stages(object) <- value

\method{[}{sevt.stgs}(x, i, ...)

\method{[}{sevt.stgs}(x, i, ..., fit = TRUE) <- value

\method{[[}{sevt.stgs}(x, ...)

\method{[[}{sevt.stgs}(x, ..., fit = TRUE) <- value
}
\arguments{
\item{object}{an object of class \code{sevt}.}

\item{x}{an object of class \code{sevt.stgs}
(obtained by \code{stages(object)}).}

\item{...}{a path or context in the event tree.}

\item{max}{integer, limit on the number of variables to print.}

\item{value}{the stages replacement value.}

\item{i}{index of variables in the tree.}

\item{fit}{logical, if TRUE (default) the model will be re-fitted.}
}
\value{
For \code{stages()}: returns an object of class
\code{sevt.stgs} which encode the stages of \code{object}.
Objects of class \code{sevt.stgs} have dedicated
method for sub-setting and replacing.
}
\description{
Functions to get or set the stages of an object of class
\code{sevt}.
}
\details{
This functions are the preferred way to access and modify directly
the stages of an object of class \code{sevt}.
In particular the indexing and replacing methods for the
object extracted with the function \code{stages()} take care of checking
the stages sanity and refit the object probabilities when needed.
This is useful for manually setting some independence statements
(see the Examples).
}
\section{Stages indexing}{

Stages can be indexed, retrieved and replaced
by the corresponding variables names and/or by
paths or contexts.

In particular,
\code{stages(object)[[var]]} extracts the
stages vector corresponding to variable \code{var} (similarly
to \code{object$stages[[var]]}.
Alternatively \code{stages(object)[[path]]} indexes
a stage via the corresponding path from root
(similar to \code{\link{get_stage}}); a path is
recognized as such if named or if of length > 2.

\code{stages(object)[var, context]} extracts multiple stages
corresponding to a variable and eventually filtered by
a specific context on the preceding variables.
}

\examples{
# start with full model
mod <- full(Titanic)

# impose the context independence Survived indep Sex, Age | Class = 1st
stages(mod)["Survived", Class = "1st"] <- "C1"

# impose Survived indep Class | Class in (2nd 3rd)
stages(mod)["Survived", Class = "3rd"] <- stages(mod)["Survived", Class = "2nd"]

# impose Age indep Class | Sex
stages(mod)["Age", Sex = "Female"] <- "S-female"
stages(mod)["Age", Sex = "Male"] <- "S-male"

# stages of Survived
stages(mod)[["Survived"]]

# stages of Survived and Age
stages(mod)[c("Survived", "Age")]

# stages of Survived in the context Class 2nd or 3rd
stages(mod)["Survived", Class = c("2nd", "3rd")]

# check independencies
as_parentslist(mod)
}
