% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_tikz.R
\name{write_tikz}
\alias{write_tikz}
\alias{write_tikz.sevt}
\title{Export the staged tree or CEG graph to tikz}
\usage{
write_tikz(
  x,
  layout = NULL,
  file = "",
  col = NULL,
  ignore = x$name_unobserved,
  node_label = function(node) {
     ifelse(is.na(node$stage), "", node$stage)
 },
  edge_label = function(edge) {
     ifelse(is.na(edge$label), "", edge$label)
 },
  edge_label_options = function(edge) {
     return("sloped")
 },
  scale = 10,
  normalize_layout = TRUE,
  node_shape = "circle",
  node_inner_sep = "1mm",
  node_minimum_size = "0.3cm",
  node_draw_color = "black",
  node_thickness = "very thick",
  node_text_color = "black"
)

\method{write_tikz}{sevt}(
  x,
  layout = NULL,
  file = "",
  col = NULL,
  ignore = x$name_unobserved,
  node_label = function(node) {
     ifelse(is.na(node$stage), "", node$stage)
 },
  edge_label = function(edge) {
     ifelse(is.na(edge$label), "", edge$label)
 },
  edge_label_options = function(edge) {
     return("sloped")
 },
  scale = 10,
  normalize_layout = TRUE,
  node_shape = "circle",
  node_inner_sep = "1mm",
  node_minimum_size = "0.3cm",
  node_draw_color = "black",
  node_thickness = "very thick",
  node_text_color = "black"
)
}
\arguments{
\item{x}{an object of class \code{\link{sevt}} or \code{\link{ceg}}.}

\item{layout}{the layout of the graph, given as matrix with two columns
and as many rows as nodes in the staged tree.
By default, a modified sugiyama layout is used.
The layout matrix can be obtained with \pkg{igraph}
layout functions.}

\item{file}{A connection or a character string naming the file to print to.
Passed to \code{\link{cat}}.}

\item{col}{color specifications for the stages of the staged even tree.
Same as \code{\link{plot.sevt}} and \code{\link{make_stages_col}}.}

\item{ignore}{vector of stages which will be ignored and not plotted,
by default the name of the unobserved stages stored in \code{x$name_unobserved}.}

\item{node_label}{a function that produces nodes labels.}

\item{edge_label}{a function that produces edge labels.}

\item{edge_label_options}{a function that produces edge label options.}

\item{scale}{for the tikzfigure.}

\item{normalize_layout}{a logical value. If \code{TRUE}
layout positions are scaled to the \code{[0,1]} interval.}

\item{node_shape}{the shape to be used for nodes.}

\item{node_inner_sep}{the \code{inner sep} parameter.}

\item{node_minimum_size}{the \code{minimum size} parameter for the nodes.}

\item{node_draw_color}{the color for line drawing the nodes.}

\item{node_thickness}{the thickness of the lines.}

\item{node_text_color}{the color for label in nodes.}
}
\description{
Generate tikz code to draw the staged tree or CEG graph.
}
\details{
This function can be used to create a working
tikz code that compile to a graph similar to the
one obtained by \code{plot.sevt(x, ...)} or
\code{plot.ceg(x, ...)}.
}
\references{
Code partially inspired by the code in
\emph{Exporting graphs to LaTeX, using igraph and TikZ}
\url{http://igraph.wikidot.com/r-recipes#toc2}
}
