% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_time_refs.R
\name{pick_time_refs}
\alias{pick_time_refs}
\title{Identify time period referents within each cohort.}
\usage{
pick_time_refs(
  df,
  cohort_var,
  cohort_ref,
  time_var,
  intervention_var = NULL,
  time_offset = -1
)
}
\arguments{
\item{df}{A data frame containing the variables in the model.}

\item{cohort_var}{String specifying the name of the column in \code{df} that
defines the intervention cohorts.}

\item{cohort_ref}{An optional string specifying the value of \code{cohort_var} to
be used as the referent in the model. If not specified, the value is taken
from the first observed value in \code{cohort_var}.}

\item{time_var}{String specifying the name of the column in \code{df} that defines
time periods over the study.}

\item{intervention_var}{String specifying the name of the column in \code{df} that
defines the intervention period. If values of \code{cohort_var} are named to match
values of \code{time_var}, this parameter is not necessary.}

\item{time_offset}{Integer specifying which time period relative to the
intervention time period should be used as the referent for each cohort.
Defaults to -1, which corresponds to the time period immediately preceding
intervention.}
}
\value{
list
}
\description{
Identify time period referents within each cohort.
}
\examples{
pick_time_refs(hosp, "cohort", "0", "yr", "intervention_yr")
}
