% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.statespacer}
\alias{predict.statespacer}
\title{State Space Model Forecasting}
\usage{
\method{predict}{statespacer}(
  object,
  addvar_list_fc = NULL,
  level_addvar_list_fc = NULL,
  self_spec_list_fc = NULL,
  forecast_period = 1,
  nsim = 0,
  ...
)
}
\arguments{
\item{object}{A statespacer object as returned by \code{\link{statespacer}}.}

\item{addvar_list_fc}{A list containing the explanatory variables for each
of the dependent variables. The list should contain p (number of dependent
variables) elements. Each element of the list should be a
\code{forecast_period} x k_p matrix, with k_p being the number of explanatory
variables for the pth dependent variable. If no explanatory variables
should be added for one of the dependent variables, then set the
corresponding element to \code{NULL}.}

\item{level_addvar_list_fc}{A list containing the explanatory variables
for each of the dependent variables. The list should contain p
(number of dependent variables) elements. Each element of the list should
be a \code{forecast_period} x k_p matrix, with k_p being the number of
explanatory variables for the pth dependent variable. If no explanatory
variables should be added for one of the dependent variables, then set
the corresponding element to \code{NULL}.}

\item{self_spec_list_fc}{A list containing the specification of the self
specified component. Does not have to be specified if it does not differ
from \code{self_spec_list} as passed on to \code{\link{statespacer}}. If some
system matrices are time-varying then you should specify this argument.
See \code{\link{statespacer}} for details about the format that must be
followed for this argument.}

\item{forecast_period}{Number of time steps to forecast ahead.}

\item{nsim}{Number of simulations to generate over the forecast period.}

\item{...}{Arguments passed on to the \code{predict} generic. Should not be used!}
}
\value{
A list containing the forecasts and corresponding uncertainties.
In addition, it returns the components of the forecasts, as specified
by the State Space model.
}
\description{
Produces forecasts and out of sample simulations using a fitted State Space Model.
}
\examples{
# Fit a SARIMA model on the AirPassengers data
library(datasets)
Data <- matrix(log(AirPassengers))
sarima_list <- list(list(s = c(12, 1), ar = c(0, 0), i = c(1, 1), ma = c(1, 1)))
fit <- statespacer(y = Data, 
                   H_format = matrix(0), 
                   sarima_list = sarima_list, 
                   initial = c(0.5*log(var(diff(Data))), 0, 0))

# Obtain forecasts for 100 steps ahead using the fitted model
fc <- predict(fit, forecast_period = 100, nsim = 10)

# Plot the forecasts and one of the simulation paths
plot(fc$y_fc, type = 'l')
lines(fc$sim$y[, 1, 1], type = 'p')
}
\references{
\insertRef{durbin2012time}{statespacer}
}
\author{
Dylan Beijers, \email{dylanbeijers@gmail.com}
}
