% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{estEffsCPP}
\alias{estEffsCPP}
\title{Estimates for covariates}
\usage{
estEffsCPP(
  y0,
  w0,
  x0,
  vg,
  ve,
  k,
  returnSe = TRUE,
  estCom = FALSE,
  nCores = NULL
)
}
\arguments{
\item{y0}{An n x p matrix of observed phenotypes, on p traits or environments
for n genotypes. No missing values are allowed.}

\item{w0}{An n x c covariate matrix, c being the number of covariates and n
being the number of genotypes. c has to be at least one (typically an
intercept). No missing values are allowed.}

\item{x0}{An n x ns matrix of marker scores. Neither missing values nor
non-segregating markers are allowed.}

\item{vg}{A p x p matrix of genetic covariances.}

\item{ve}{A p x p matrix of environmental covariances.}

\item{k}{An n x n genetic relatedness matrix.}

\item{returnSe}{Should standard errors and p-values be returned?}

\item{estCom}{Should the common SNP-effect model be fitted?}

\item{nCores}{An integer indicating the number of cores used for parallel
computation.}
}
\value{
A list containing the estimates, optionally the standard errors of
the estimates and corresponding p-values. If \code{estCom = TRUE} also
common SNP-effects, their standard errors and corresponding p-values and
the p-values for QtlxE are output.
}
\description{
Compute the estimates and standard errors for the covariates in the input
matrix W.
}
\references{
Zhou, X. and Stephens, M. (2014). Efficient multivariate linear
mixed model algorithms for genome-wide association studies. Nature Methods,
February 2014, Vol. 11, p. 407–409
}
\keyword{internal}
