# STATIS DATA

#' Physicochemical Variables Dataset for STATIS Analysis
#'
#' This dataset belongs to a project called “Development and application of effective, low-cost methods for the biological monitoring of Costa Rican rivers”
#' by the National University, and contains measurements of various physicochemical variables collected across several sampling sites.
#' It is intended to be used in the
#' examples and demonstrations of the main functions of the package,
#' particularly those related to multivariate analysis and STATIS methodology.
#'
#' @format A data frame with 14 columns and multiple rows (one per sampling site):
#' \describe{
#'   \item{NIT}{Total nitrogen level.}
#'   \item{FOS}{Phosphorus level.}
#'   \item{CAL}{Calcium level.}
#'   \item{STO}{Sodium level.}
#'   \item{PH}{pH measurement.}
#'   \item{MN}{Manganese concentration.}
#'   \item{ZN}{Zinc concentration.}
#'   \item{SS}{Suspended solids.}
#'   \item{ALC}{Alkalinity.}
#'   \item{CL}{Chlorine level.}
#'   \item{CAU}{Exchangeable calcium or equivalent measurement.}
#'   \item{DBO}{Biological oxygen demand.}
#'   \item{POR}{Porosity or related percentage.}
#' }
#'
#' @keywords datasets
#' @usage data(STATIS_TABLE1)
#'
#' @examples
#' data(STATIS_TABLE1)
#' head(STATIS_TABLE1)
#'
"STATIS_TABLE1"


#' Physicochemical Variables Dataset for STATIS Analysis
#'
#' This dataset belongs to a project called “Development and application of effective, low-cost methods for the biological monitoring of Costa Rican rivers”
#' by the National University, and contains measurements of various physicochemical variables collected across several sampling sites.
#' It is intended to be used in the
#' examples and demonstrations of the main functions of the package,
#' particularly those related to multivariate analysis and STATIS methodology.
#'
#' @format A data frame with 14 columns and multiple rows (one per sampling site):
#' \describe{
#'   \item{NIT}{Total nitrogen level.}
#'   \item{FOS}{Phosphorus level.}
#'   \item{CAL}{Calcium level.}
#'   \item{STO}{Sodium level.}
#'   \item{PH}{pH measurement.}
#'   \item{MN}{Manganese concentration.}
#'   \item{ZN}{Zinc concentration.}
#'   \item{SS}{Suspended solids.}
#'   \item{ALC}{Alkalinity.}
#'   \item{CL}{Chlorine level.}
#'   \item{CAU}{Exchangeable calcium or equivalent measurement.}
#'   \item{DBO}{Biological oxygen demand.}
#'   \item{POR}{Porosity or related percentage.}
#' }
#'
#' @keywords datasets
#' @usage data(STATIS_TABLE1)
#'
#' @examples
#' data(STATIS_TABLE2)
#' head(STATIS_TABLE2)
#'
"STATIS_TABLE2"


#' Physicochemical Variables Dataset for STATIS Analysis
#'
#' This dataset belongs to a project called “Development and application of effective, low-cost methods for the biological monitoring of Costa Rican rivers”
#' by the National University, and contains measurements of various physicochemical variables collected across several sampling sites.
#' It is intended to be used in the
#' examples and demonstrations of the main functions of the package,
#' particularly those related to multivariate analysis and STATIS methodology.
#'
#' @format A data frame with 14 columns and multiple rows (one per sampling site):
#' \describe{
#'   \item{NIT}{Total nitrogen level.}
#'   \item{FOS}{Phosphorus level.}
#'   \item{CAL}{Calcium level.}
#'   \item{STO}{Sodium level.}
#'   \item{PH}{pH measurement.}
#'   \item{MN}{Manganese concentration.}
#'   \item{ZN}{Zinc concentration.}
#'   \item{SS}{Suspended solids.}
#'   \item{ALC}{Alkalinity.}
#'   \item{CL}{Chlorine level.}
#'   \item{CAU}{Exchangeable calcium or equivalent measurement.}
#'   \item{DBO}{Biological oxygen demand.}
#'   \item{POR}{Porosity or related percentage.}
#' }
#'
#' @keywords datasets
#' @usage data(STATIS_TABLE3)
#'
#' @examples
#' data(STATIS_TABLE3)
#' head(STATIS_TABLE3)
#'
"STATIS_TABLE3"


#' Physicochemical Variables Dataset for STATIS Analysis
#'
#' This dataset belongs to a project called “Development and application of effective, low-cost methods for the biological monitoring of Costa Rican rivers”
#' by the National University, and contains measurements of various physicochemical variables collected across several sampling sites.
#' It is intended to be used in the
#' examples and demonstrations of the main functions of the package,
#' particularly those related to multivariate analysis and STATIS methodology.
#'
#' @format A data frame with 14 columns and multiple rows (one per sampling site):
#' \describe{
#'   \item{NIT}{Total nitrogen level.}
#'   \item{FOS}{Phosphorus level.}
#'   \item{CAL}{Calcium level.}
#'   \item{STO}{Sodium level.}
#'   \item{PH}{pH measurement.}
#'   \item{MN}{Manganese concentration.}
#'   \item{ZN}{Zinc concentration.}
#'   \item{SS}{Suspended solids.}
#'   \item{ALC}{Alkalinity.}
#'   \item{CL}{Chlorine level.}
#'   \item{CAU}{Exchangeable calcium or equivalent measurement.}
#'   \item{DBO}{Biological oxygen demand.}
#'   \item{POR}{Porosity or related percentage.}
#' }
#'
#' @keywords datasets
#' @usage data(STATIS_TABLE4)
#'
#' @examples
#' data(STATIS_TABLE4)
#' head(STATIS_TABLE4)
#'
"STATIS_TABLE4"


#' Sensory Evaluation Data from Expert 1
#'
#' This dataset contains the ratings provided by Expert 1 for six wine samples.
#' Each wine is evaluated according to three sensory attributes commonly used
#' in descriptive analysis: \emph{fruity}, \emph{woody}, and \emph{coffee}.
#' The dataset is typically used in STATIS and multitable analyses to illustrate
#' how different experts evaluate the same set of products.
#'
#' @format A data frame with 6 rows (Wine1–Wine6) and 3 sensory attributes:
#' \describe{
#'   \item{fruity}{Intensity of fruity aromas.}
#'   \item{woody}{Intensity of woody/aged aromas.}
#'   \item{coffee}{Perceived coffee-like notes.}
#' }
#'
#' @keywords datasets
#' @usage data(expert1)
#' @references Abdi, H., & Valentin, D. (2007). The STATIS method. Encyclopedia of measurement and statistics, 955-962.
#'
#' @examples
#' data(expert1)
#' expert1
#'
"expert1"


#' Sensory Evaluation Data from Expert 2
#'
#' This dataset contains the evaluations provided by Expert 2 for the same six wine samples.
#' Unlike Expert 1, this expert uses four sensory descriptors:
#' \emph{red_fruit}, \emph{roasted}, \emph{vanillin}, and \emph{woody}.
#' The dataset demonstrates how experts may differ in terminology and profiling,
#' and it is commonly used in STATIS, MFA, and other multitable comparison techniques.
#'
#' @format A data frame with 6 rows (Wine1–Wine6) and 4 sensory attributes:
#' \describe{
#'   \item{red_fruit}{Intensity of red fruit aromas.}
#'   \item{roasted}{Intensity of roasted or toasted notes.}
#'   \item{vanillin}{Perceived vanilla-related notes.}
#'   \item{woody}{Intensity of woody/aged aromas.}
#' }
#'
#' @keywords datasets
#' @usage data(expert2)
#' @references Abdi, H., & Valentin, D. (2007). The STATIS method. Encyclopedia of measurement and statistics, 955-962.
#'
#' @examples
#' data(expert2)
#' expert2
#'
"expert2"


#' Sensory Evaluation Data from Expert 3
#'
#' This dataset contains the ratings given by Expert 3 for the same set of six wine samples.
#' This expert evaluates wines using three sensory attributes:
#' \emph{fruity}, \emph{butter}, and \emph{woody}.
#' The dataset is often used in multivariate and STATIS examples to highlight
#' both agreement and divergence across panels of experts.
#'
#' @format A data frame with 6 rows (Wine1–Wine6) and 3 sensory attributes:
#' \describe{
#'   \item{fruity}{Intensity of fruity aromas.}
#'   \item{butter}{Presence of buttery or lactic notes.}
#'   \item{woody}{Intensity of woody/aged aromas.}
#' }
#'
#' @keywords datasets
#' @usage data(expert3)
#' @references Abdi, H., & Valentin, D. (2007). The STATIS method. Encyclopedia of measurement and statistics, 955-962.
#'
#' @examples
#' data(expert3)
#' expert3
#'
"expert3"


# STATIS DUAL DATA

#' Physicochemical Quality Data (Tuis5_95)
#'
#' This dataset contains physicochemical measurements collected from a Sugarcane Fertilizer experiment in Costa Rica.
#' The values represent indicators measured during a monitoring campaign. The dataset
#' is useful for illustrating multivariate methods, STATIS analyses, or
#' environmental data exploration workflows.
#'
#' @format A data frame with 10 observations and 19 variables:
#' \describe{
#'   \item{Ph}{pH value of the sample.}
#'   \item{Temp}{Temperature (°C).}
#'   \item{Na}{Sodium concentration.}
#'   \item{Ka}{Potassium concentration.}
#'   \item{Ca}{Calcium concentration.}
#'   \item{Mg}{Magnesium concentration.}
#'   \item{Si02}{Silica concentration.}
#'   \item{OD}{Dissolved oxygen.}
#'   \item{DBO}{Biochemical oxygen demand (BOD).}
#'   \item{SD}{Dissolved solids.}
#'   \item{ST}{Total solids.}
#'   \item{PO4}{Phosphate concentration.}
#'   \item{Cl}{Chloride concentration.}
#'   \item{NO3}{Nitrate concentration.}
#'   \item{SO45}{Sulfate concentration.}
#'   \item{HC03}{Bicarbonate concentration.}
#'   \item{DT}{Total hardness or related measurement.}
#'   \item{POD}{Dissolved oxygen percentage or related measure.}
#'   \item{Cal}{Calcium-related parameter (likely residual hardness).}
#' }
#'
#' @keywords datasets
#' @usage data(Tuis5_95)
#'
#' @examples
#' data(Tuis5_95)
#' head(Tuis5_95)
#'
"Tuis5_95"


#' Physicochemical Quality Data (Tuis5_96)
#'
#' This dataset contains physicochemical measurements collected from a Sugarcane Fertilizer experiment in Costa Rica.
#' The values represent indicators measured during a monitoring campaign. The dataset
#' is useful for illustrating multivariate methods, STATIS analyses, or
#' environmental data exploration workflows.
#'
#' @format A data frame with 12 observations and 19 variables:
#' \describe{
#'   \item{Ph}{pH value of the water sample.}
#'   \item{Temp}{Temperature (°C).}
#'   \item{Na}{Sodium concentration.}
#'   \item{Ka}{Potassium concentration.}
#'   \item{Ca}{Calcium concentration.}
#'   \item{Mg}{Magnesium concentration.}
#'   \item{Si02}{Silica concentration.}
#'   \item{OD}{Dissolved oxygen.}
#'   \item{DBO}{Biochemical oxygen demand (BOD).}
#'   \item{SD}{Dissolved solids.}
#'   \item{ST}{Total solids.}
#'   \item{PO4}{Phosphate concentration.}
#'   \item{Cl}{Chloride concentration.}
#'   \item{NO3}{Nitrate concentration.}
#'   \item{SO45}{Sulfate concentration.}
#'   \item{HC03}{Bicarbonate concentration.}
#'   \item{DT}{Total hardness or related parameter.}
#'   \item{POD}{Dissolved oxygen percentage or related measurement.}
#'   \item{Cal}{Calcium-related parameter (e.g., residual hardness).}
#' }
#'
#' @keywords datasets
#' @usage data(Tuis5_96)
#'
#' @examples
#' data(Tuis5_96)
#' head(Tuis5_96)
#'
"Tuis5_96"


#' Physicochemical Quality Data (Tuis5_97)
#'
#' This dataset contains physicochemical measurements collected from a Sugarcane Fertilizer experiment in Costa Rica.
#' The values represent indicators measured during a monitoring campaign. The dataset
#' is useful for illustrating multivariate methods, STATIS analyses, or
#' environmental data exploration workflows.
#'
#' @format A data frame with 12 observations and 19 variables:
#' \describe{
#'   \item{Ph}{pH value of the water sample.}
#'   \item{Temp}{Temperature (°C).}
#'   \item{Na}{Sodium concentration.}
#'   \item{Ka}{Potassium concentration.}
#'   \item{Ca}{Calcium concentration.}
#'   \item{Mg}{Magnesium concentration.}
#'   \item{Si02}{Silica concentration.}
#'   \item{OD}{Dissolved oxygen.}
#'   \item{DBO}{Biochemical oxygen demand (BOD).}
#'   \item{SD}{Dissolved solids.}
#'   \item{ST}{Total solids.}
#'   \item{PO4}{Phosphate concentration.}
#'   \item{Cl}{Chloride concentration.}
#'   \item{NO3}{Nitrate concentration.}
#'   \item{SO45}{Sulfate concentration.}
#'   \item{HC03}{Bicarbonate concentration.}
#'   \item{DT}{Total hardness or related parameter.}
#'   \item{POD}{Dissolved oxygen percentage or related measure.}
#'   \item{Cal}{Calcium-related parameter (e.g., residual hardness).}
#' }
#'
#' @keywords datasets
#' @usage data(Tuis5_97)
#'
#' @examples
#' data(Tuis5_97)
#' head(Tuis5_97)
#'
"Tuis5_97"


#' Physicochemical Quality Data (Tuis5_98)
#'
#' This dataset contains physicochemical measurements collected from a Sugarcane Fertilizer experiment in Costa Rica.
#' The values represent indicators measured during a monitoring campaign. The dataset
#' is useful for illustrating multivariate methods, STATIS analyses, or
#' environmental data exploration workflows.
#'
#' @format A data frame with 12 observations and 19 variables:
#' \describe{
#'   \item{Ph}{pH value of the water sample.}
#'   \item{Temp}{Temperature (°C).}
#'   \item{Na}{Sodium concentration.}
#'   \item{Ka}{Potassium concentration.}
#'   \item{Ca}{Calcium concentration.}
#'   \item{Mg}{Magnesium concentration.}
#'   \item{Si02}{Silica concentration.}
#'   \item{OD}{Dissolved oxygen.}
#'   \item{DBO}{Biochemical oxygen demand (BOD).}
#'   \item{SD}{Dissolved solids.}
#'   \item{ST}{Total solids.}
#'   \item{PO4}{Phosphate concentration.}
#'   \item{Cl}{Chloride concentration.}
#'   \item{NO3}{Nitrate concentration.}
#'   \item{SO45}{Sulfate concentration.}
#'   \item{HC03}{Bicarbonate concentration.}
#'   \item{DT}{Total hardness or related parameter.}
#'   \item{POD}{Dissolved oxygen percentage or related measurement.}
#'   \item{Cal}{Calcium-related parameter (e.g., residual hardness).}
#' }
#'
#' @keywords datasets
#' @usage data(Tuis5_98)
#'
#' @examples
#' data(Tuis5_98)
#' head(Tuis5_98)
#'
"Tuis5_98"
