% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.agree}
\alias{ci.agree}
\title{Confidence interval for a G-index of agreement}
\usage{
ci.agree(alpha, n, f, k)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{sample size}

\item{f}{number of objects rated in agreement}

\item{k}{number of rating categories}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - maximum likelihood estimate of G-index
\item SE - standard error
\item LL - lower limit of the adjusted Wald confidence interval
\item UL - upper limit of the adjusted Wald confidence interval
}
}
\description{
Computes an adjusted Wald confidence interval for a G-index of agreement
between two polychotomous ratings. This function requires the number of
objects that were given the same rating by both raters. The G-index
corrects for chance agreement. The G-index is a better measure of
agreement than Cohen's kappa, and the confidence interval for the G-index
used here has better small-sample properties than the confidence interval
for Cohen's kappa.

For more details, see Section 3.5 of Bonett (2021, Volume 3)
}
\examples{
ci.agree(.05, 250, 214, 3)

# Should return:
#  Estimate      SE     LL     UL
#     0.784 0.03331 0.7098 0.8414


}
\references{
\insertRef{Bonett2022}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
