% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.ratio.cod2}
\alias{ci.ratio.cod2}
\title{Confidence interval for a ratio of dispersion coefficients in a 2-group
design}
\usage{
ci.ratio.cod2(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of scores in group 1}

\item{y2}{vector of scores in group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item COD1 - estimated coefficient of dispersion in group 1
\item COD2 - estimated coefficient of dispersion in group 2
\item COD1/COD2 - estimated ratio of dispersion coefficients
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a ratio of population dispersion
coefficients (mean absolute deviation from median divided by median)
in a 2-group design. Ratio-scale scores are assumed.
}
\examples{
y1 <- c(32, 39, 26, 35, 43, 27, 40, 37, 34, 29)
y2 <- c(36, 44, 47, 42, 49, 39, 46, 31, 33, 48)
ci.ratio.cod2(.05, y1, y2)

# Should return:
#      COD1      COD2 COD1/COD2       LL       UL
# 0.1333333 0.1232558  1.081761 0.494964 2.282254


}
