% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate_formula}
\alias{validate_formula}
\title{Validate Formula Variables}
\usage{
validate_formula(
  formula,
  data = NULL,
  func_name = "function",
  calling_env = parent.frame()
)
}
\arguments{
\item{formula}{A potential formula object to validate (can be any object).}

\item{data}{An optional data frame containing the variables.}

\item{func_name}{Character string. Name of the calling function (for error messages).}

\item{calling_env}{The environment in which to look for variables if data is not provided.
Defaults to parent.frame().}
}
\value{
Returns NULL invisibly. Stops with an error if validation fails.
}
\description{
Checks if the input is a formula and validates that all variables mentioned
in the formula exist either in the provided data frame or in the environment.
This is a lightweight validation function that should be called early in functions
that accept formula syntax.
}
\keyword{internal}
