% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StandardScale.R
\name{StandardScale}
\alias{StandardScale}
\alias{print.StandardScale}
\alias{plot.StandardScale}
\title{Specify standard scale}
\usage{
StandardScale(name, M, SD, min, max)

\method{print}{StandardScale}(x, ...)

\method{plot}{StandardScale}(x, n = 1000, ...)
}
\arguments{
\item{name}{Name of the scale}

\item{M}{Mean of the scale}

\item{SD}{Standard deviation of the scale}

\item{min}{Minimal value the scale takes}

\item{max}{Maximal value the scale takes}

\item{x}{a \code{StandardScale} object}

\item{...}{further arguments passed to or from other methods.}

\item{n}{Number of points the plot generates. The higher the number, the more
detailed are the plots. Default to 1000 for nicely detailed plot.}
}
\value{
StandardScale object
}
\description{
\code{StandardScale} objects are used with \code{\link[=ScoreTable]{ScoreTable()}} or
\code{\link[=GroupedScoreTable]{GroupedScoreTable()}} objects to recalculate \code{\link[=FrequencyTable]{FrequencyTable()}} or
\code{\link[=GroupedFrequencyTable]{GroupedFrequencyTable()}} into some standardized scale score.

There are few \code{StandardScale} defaults available.

Plot method requires \code{ggplot2} package to be installed.
}
