% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv2.R
\name{cv2}
\alias{cv2}
\alias{templ_cv2}
\title{Steve's Second Academic CV Template}
\usage{
cv2(...)

templ_cv2()
}
\arguments{
\item{...}{Arguments to \code{\link[rmarkdown:pdf_document]{rmarkdown::pdf_document}}.}
}
\description{
A template for academic CVs. This is an evolution of the first one, though
has slightly different aesthetic features you can see for yourself. For more
information, see here: \url{http://svmiller.com/blog/2016/03/svm-r-markdown-cv/}.
You can also check my current CV.
}
\section{About YAML header fields}{
This section documents some of the YAML fields to know
for this template.\tabular{ll}{
   FIELD \tab DESCRIPTION \cr
   \code{author} \tab name of the author \cr
   \code{jobtitle} \tab appears as first row in the CV \cr
   \code{address} \tab appears as second row in the CV \cr
   \code{fontawesome} \tab logical, defaults to \code{TRUE}. If \code{TRUE}, use fontawesome icons \cr
   \code{email} \tab your email, for the third row \cr
   \code{github} \tab optional, displays Github user name on third row \cr
   \code{orcid} \tab optional, displays ORCID ID on third row \cr
   \code{phone} \tab optional, displays your phone number on third row \cr
   \code{web} \tab optional, displays your domain name on third row \cr
   \code{updated} \tab optional, displays (on third row) when file was last updated. If FALSE or omitted, date of update is communicated in footer \cr
   \code{rdateformat} \tab optional, but takes R syntax to format date of update. \cr
   \code{keywords} \tab not terribly useful, but some keywords to embed in PDF so Google may find it \cr
}
}

\section{Additional Comments}{
The \code{fontawesome} argument calls the \code{fontawesome5} package in LaTeX. This
assumes the use of TeXLive 2015 at the latest.

\code{latex_engine} is hard-set as "xelatex". This permits greater flexibility in
use of fonts through the \code{mainfont} argument you can specify in the YAML.

I'll be frank that disabling \code{fontawesome} doesn't make much sense to me,
though the option is there if you want it. The CV just won't look as nice
with it disabled.

\code{fontawesome} controls the use of icons in the header, though icons for
ORCID and OSF come from the \code{academicicons} package. Everything else comes
from \code{fontawesome5}.
}

