% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_shareValueDDMconstantGrowth.R
\name{shareValueGGMconstantGrowth}
\alias{shareValueGGMconstantGrowth}
\title{Calculates DDM value of share under the assumption that Dividends are to grow at constant rate.}
\usage{
shareValueGGMconstantGrowth(dividend, r, g, divN)
}
\arguments{
\item{dividend}{A number.}

\item{r}{A number.}

\item{g}{A number.}

\item{divN}{A number.}
}
\value{
Input values to four arguments  \code{dividend}, \code{r} and  \code{g} and \code{divN}.
}
\description{
The simplest pattern that can be assumed in forecasting future dividends is that dividends will grow at a constant rate. So, \code{DividendN1}  is equal to \code{dividendNt} multiplied with (1 + g). Here, \code{DividendN1} expected dividend to be paid after one year and \code{dividendNt} is current dividend (Jerald E. Pinto, 2020).
}
\details{
According to information provided by Jerald E. Pinto (2020), the method \code{shareValueDDMconstantGrowth} is developed to compute DDM value of share under the assumption that Dividends are to grow at constant rate for the values passed to its four arguments.Here, \code{dividend} is current dividend, \code{g} is rate of constant growth, \code{r} is the required rate of return on the stock ,and \code{divN} lets you make choice between D0 or D1 (that is either using current dividend (D0) or Dividend in one year (D1) as \code{dividend} in the first argument of \code{shareValueDDMconstantGrowth}).
}
\examples{
shareValueGGMconstantGrowth(dividend=1.1024,r=0.101,g=0.06,divN=1)
shareValueGGMconstantGrowth(dividend=1.04,r=0.101,g=0.06,divN=0)
}
\references{
Pinto, J. E. (2020). Equity Asset Valuation (4th ed.). Wiley Professional Development (P&T). https://bookshelf.vitalsource.com/books/9781119628194
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
