% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node-funs.R
\name{route_nearest_point}
\alias{route_nearest_point}
\title{Find nearest route to a given point}
\usage{
route_nearest_point(r, p, id_out = FALSE)
}
\arguments{
\item{r}{The input route object from which the nearest route is to be found}

\item{p}{The point whose nearest route will be found}

\item{id_out}{Should the index of the matching feature be returned? \code{FALSE} by default}
}
\description{
This function was written as a drop-in replacement for \code{sf::st_nearest_feature()},
which only works with recent versions of GEOS.
}
\examples{
r <- routes_fast_sf[2:6, NULL]
p <- sf::st_sfc(sf::st_point(c(-1.540, 53.826)), crs = sf::st_crs(r))
route_nearest_point(r, p, id_out = TRUE)
r_nearest <- route_nearest_point(r, p)
plot(r$geometry)
plot(p, add = TRUE)
plot(r_nearest, lwd = 5, add = TRUE)
}
