/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.lazy;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import java.util.ArrayList;
import moa.classifiers.MultiClassClassifier;
import moa.classifiers.core.driftdetection.ADWIN;
import moa.classifiers.lazy.kNN;

public class kNNwithPAWandADWIN
extends kNN
implements MultiClassClassifier {
    private static final long serialVersionUID = 1L;
    private ADWIN adwin;
    protected int marker = 0;
    protected ArrayList<Integer> timeStamp;
    protected double prob;
    protected int time;

    @Override
    public String getPurposeString() {
        return "kNNwithPAWandADWIN: kNN with Probabilistic Approximate Window and ADWIN";
    }

    @Override
    public void resetLearningImpl() {
        this.window = null;
        this.adwin = new ADWIN();
        this.prob = Math.pow(2.0, -1.0 / (double)this.limitOption.getValue());
        this.time = 0;
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (inst.classValue() > (double)this.C) {
            this.C = (int)inst.classValue();
        }
        if (this.window == null) {
            this.window = new Instances(inst.dataset());
        }
        if (this.timeStamp == null) {
            this.timeStamp = new ArrayList(10);
        }
        for (int i = 0; i < this.window.size(); ++i) {
            if (!(this.classifierRandom.nextDouble() > this.prob)) continue;
            this.window.delete(i);
            this.timeStamp.remove(i);
        }
        this.window.add(inst);
        this.timeStamp.add(this.time);
        ++this.time;
        boolean correctlyClassifies = this.correctlyClassifies(inst);
        if (this.adwin.setInput(correctlyClassifies ? 0.0 : 1.0)) {
            int size = this.adwin.getWidth();
            for (int i = 0; i < this.window.size(); ++i) {
                if (this.timeStamp.get(i) >= this.time - size) continue;
                this.window.delete(i);
                this.timeStamp.remove(i);
            }
        }
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }
}

