% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholds.R
\name{calc_thresh}
\alias{calc_thresh}
\title{Calculate seasonal thresholds}
\usage{
calc_thresh(values, seasons, years, center_year, half_win = 2, threshold = 0.8)
}
\arguments{
\item{values}{A numeric vector.}

\item{seasons}{A vector indicating the season for each observation in \code{values}.}

\item{years}{A numeric vector indicating the year for each observation in \code{values}.}

\item{center_year}{The center year around which the window is defined.}

\item{half_win}{The half width of the window of years to group \code{values} by.}

\item{threshold}{The quantile of \code{values}.}
}
\value{
A data frame with the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
season \tab integer \tab Season of the threshold \cr
threshold \tab numeric \tab Seasonal threshold \cr
center_year \tab integer \tab Middle year of the window \cr
}
}
\description{
\code{calc_thresh()} calculates thresholds for data within a specified window around a
given year. The thresholds are calculated for each season based on a specified quantile.
}
\keyword{internal}
