% Generated by roxygen2 (4.0.1): do not edit by hand
\name{stressAreaChart}
\alias{stressAreaChart}
\title{Financial stress component data as a stacked area chart.}
\usage{
stressAreaChart(e, range = NA)
}
\arguments{
\item{e}{an object of class \code{stress} as returned by \code{\link[stressr]{getStressComponents}} and its many offspring.}

\item{range}{a range string as used by \code{xts} to subset time series dates, e.g. "1996/1997".  Defaults to NA for full range.}
}
\description{
Provides a convenience function for passing a \code{stress} object to \code{xyplot} to render a sand (stacked area) chart.
}
\details{
Provides several assumptions about the display of the \code{stress} data to correspond to similar presentations at the Cleveland Fed's data site.  To implement the stacked area chart the function first computes the column-wise value accumulations, then passes these values to the \code{latticeExtra} \code{xyarea} polygon rendering tools.  Plots the columns in reverse stacking order to show the desired overlaps.
}
\examples{
\dontrun{
es <- getEquityStress()
stressAreaChart(es)
}
}
\seealso{
xyplot.stress stressLineChart getStressComponents getComponentSummary getEquityMarkets getFundingMarkets getCreditMarkets getForeignExchangeMarkets getRealEstateMarkets getSecuritizationMarkets
}

