% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isalpha.R
\name{strs_isalpha}
\alias{strs_isalpha}
\title{Check if string contains only alphabetical characters}
\usage{
strs_isalpha(string)
}
\arguments{
\item{string}{A character vector to be checked.}
}
\value{
A logical vector of the same length as \code{string}, indicating whether
each element contains only alphabetical characters.
}
\description{
\code{strs_isalpha} checks whether each element of a character vector contains
only alphabetical characters. It is similar to Python's \code{str.isalpha()}
method.
}
\examples{
strs_isalpha("hello")
strs_isalpha("hello123")
}
\seealso{
\href{https://docs.python.org/3/library/stdtypes.html#str.isalpha}{Python str.isalpha() documentation}
}
