% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporal_means.R
\name{temporal_means}
\alias{temporal_means}
\alias{temporal_means.data.frame}
\alias{temporal_means.stars}
\alias{autoplot.temporalmeans}
\title{Computes temporal empirical means using a dataframe or a stars object.}
\usage{
temporal_means(x, ...)

\method{temporal_means}{data.frame}(x, t_col, z_col, id_col, ...)

\method{temporal_means}{stars}(x, ...)

\method{autoplot}{temporalmeans}(
  object,
  ylab = "Value",
  xlab = "Time",
  legend_title = "",
  title = "Temporal Empirical Means",
  ...
)
}
\arguments{
\item{x}{A stars object or a dataframe. Arguments differ according to the input type.}

\item{...}{Other arguments currently ignored.}

\item{t_col}{For dataframes: the time column. Time must be a set of discrete integer values.}

\item{z_col}{For dataframes: the The quantity of interest that will be plotted. Eg. temperature.}

\item{id_col}{The column of the location id.}

\item{object}{For autoplot: the output of the function `temporal_means'.}

\item{ylab}{The y label.}

\item{xlab}{The x label.}

\item{legend_title}{For autoplot: the title for the legend.}

\item{title}{The graph title.}
}
\value{
An object of class temporalmeans containing the averages and the original data
in two dataframes.
}
\description{
This function computes temporal empirical means averaged per time unit.
This function can take either a stars object or a dataframe. Input arguments
differ for each case. The function autoplot plots the output.
}
\examples{
# dataframe example
data(NOAA_df_1990)
library(dplyr)
Tmax <- filter(NOAA_df_1990,                      # subset the data
              proc == "Tmax" &                   # extract max temperature
                month \%in\% 5:9 &                 # May to July
                year == 1993)                    # year 1993
Tmax$t <- Tmax$julian - min(Tmax$julian) + 1      # create a new time variable starting at 1
tem <- temporal_means(Tmax,
       t_col = 'date',
       z_col = 'z',
       id_col = 'id')
autoplot(tem)

# stars example
library(stars)
library(dplyr)
library(units)
# Example
prec_file = system.file("nc/test_stageiv_xyt.nc", package = "stars")
prec <- read_ncdf(prec_file)
temporal_means(prec)
}
