\name{bws.questionnaire}
\alias{bws.questionnaire}
\title{
Converting a two-level OMED/BIBD into BWS questions
}
\description{
This function converts a two-level orthogonal main-effect design (OMED)/balanced incomplete block design (BIBD) into a series of BWS questions.
}
\usage{
bws.questionnaire(choice.sets, design.type, item.names)
}
\arguments{
  \item{choice.sets}{
A data frame or matrix containing choice sets.
}
  \item{design.type}{
A value describing how to design the choice sets: \code{1} if the design assigned to \code{choice.sets} is a two-level OMED, and \code{2} if it is a BIBD.
}
  \item{item.names}{
A vector containing the names of items shown in the questions.
}
}
\details{
A two-level OMED/BIBD is assigned to \code{choice.sets}, and may be generated by R functions (e.g., the \code{\link[DoE.base]{oa.design}} function in \pkg{DoE.base}; the \code{\link[crossdes]{find.BIB}} function in \pkg{crossdes}) or copied manually from text books/web sites related to the design of experiments.

When the design is a two-level OMED, each row corresponds to a question and each column corresponds to an item. The level values in the design have to be 1 and 2. The former corresponds to an item being \dQuote{absent} from a column and the latter corresponds to the item being \dQuote{present.} The correspondence between item names and columns is defined and assigned to the argument \code{item.names}: the order of names in the vector assigned to \code{item.names} corresponds to the order of columns (from left to right) in the choice sets assigned to \code{choice.sets}.

When the design is a BIBD, each row corresponds to a question and the number of columns is equal to the number of items per question. The level values in the design have to be serial integer values, starting from 1: each value corresponds to an item. The correspondence between item names and level values is defined and assigned to the argument \code{item.names}: the order of names in \code{item.names} corresponds to the order of level values in the design (i.e., the \eqn{j} th item in \code{item.names} corresponds to the level value of \eqn{j} in the design).
}
\value{
BWS questions converted from the design are returned.
}
\author{
Hideo Aizaki
}
\seealso{
\code{\link[support.BWS]{bws.dataset}}, \code{\link[DoE.base]{oa.design}}, \code{\link[crossdes]{find.BIB}}
}
\examples{
## See examples in bws.dataset()
}
\keyword{ print }

