% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crisk_multi.R
\name{crisk_multi}
\alias{crisk_multi}
\title{Modify the Output for a Multi-variable Competing Risk Analysis .}
\usage{
crisk_multi(dat, csurv, cevent, convars = NULL, catvars = NULL)
}
\arguments{
\item{dat}{a data.frame in which to interpret the variables.}

\item{csurv}{this is the follow up time.}

\item{cevent}{the status indicator, normally 0=alive, 1=dead.}

\item{convars}{a vector of con variable names.}

\item{catvars}{a vector of cat variable names.}
}
\value{
a tibble of competing risk analysis output.
}
\description{
Create a table with the general multi-variable competing risk analysis results, including the HR (95 percent CI), P value.
}
\examples{
Dat <- MASS::Melanoma
Dat$time <- Dat$time/30.5
con_var <- c("age","thickness")
cat_var <- c("sex","ulcer")
multi_out <- crisk_multi(Dat, "time", "status", catvars = cat_var, convars =con_var)

}
