% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml_helpers.R
\name{get_element_dimensions}
\alias{get_element_dimensions}
\title{Get the dimensions of an SVG element}
\usage{
get_element_dimensions(
  element,
  doc_unit,
  dpi = 150,
  call = rlang::caller_env()
)
}
\arguments{
\item{element}{An xml2 node corresponding to an SVG element}

\item{doc_unit}{The unit used in the SVG document (e.g., "px", "mm", "cm", "in")}

\item{dpi}{The resolution to use when interpreting pixel units}

\item{call}{The calling environment for error reporting}
}
\value{
A list with x, y, width, and height of the element
}
\description{
Get the dimensions of an SVG element
}
\details{
The function expects the element to have 'x', 'y', 'width', and 'height' attributes.
}
